package com.hp.message.enums;

/**
 * @author 尚肖磊
 *  2021-03-27 16:22
 *  apiRespCode类型枚举
 *
 * 规定
 * #0 表示成功
 * #999 表示默认失败
 * #1001~1999 区间表示参数错误
 * #2001~2999 区间表示用户错误
 * #3001~3999 区间表示接口异常
 *
 */

public enum RespCodeType {

    /**
     * 成功
     */
    RESP_SUCCESS(0, "成功"),

    RESP_404_FAIL(404, "接口不存在"),

    /**
     * 默认失败
     */
    RESP_FAIL(500, "未知错误"),

    /**
     * 服务不可用
     */
    RESP_SERVICE_UNAVAILABLE(503, "服务不可用"),

    /**
     * 参数错误：1000～1999
     *
     */
    RESP_PARAM_NOT_VALID(1001, "参数无效"),
    RESP_PARAM_IS_BLANK(1002, "参数为空"),
    RESP_PARAM_INVALID_PHONE(1003, "无效手机号"),
    RESP_PARAM_INVALID_PASSWORD(1004, "无效密码"),
    RESP_PARAM_INVALID_SMSCODE(1005, "无效验证码"),
    RESP_PARAM_INVALID_ENUM(1006, "枚举参数不匹配"),
    RESP_PARAM_TIME_FORMAT_ERROR(1007, "时间格式不匹配"),
    RESP_PARAM_TIME_LIMIT_7(1008, "最大可查询7天"),
    RESP_PARAM_TIME_LIMIT_30(1009, "最大可查询30天"),

    /**
     * 用户错误
     *
     */
    RESP_USER_NOT_LOGIN(2001, "账号未登录"),
    RESP_USER_ACCOUNT_EXPIRED(2002, "账号已过期"),
    RESP_USER_CREDENTIALS_ERROR(2003, "密码错误"),
    RESP_USER_CREDENTIALS_EXPIRED(2004, "密码过期"),
    RESP_USER_ACCOUNT_DISABLE(2005, "账号被禁用"),
    RESP_USER_ACCOUNT_LOCKED(2006, "账号被锁定"),
    RESP_USER_ACCOUNT_NOT_EXIST(2007, "账号不存在"),
    RESP_USER_ACCOUNT_ALREADY_EXIST(2008, "账号已存在"),
    RESP_USER_ACCOUNT_LOGIN_OTHERS(2009, "账号在其他地方登录，被迫下线"),
    RESP_USER_TOKEN_EXPIRED(2010, "账号登录过期"),
    RESP_USER_LOGIN_STATUS_EXCEPTION(2011, "账号登录状态异常"),
    RESP_USER_UNKNOWN_ERROR(2999, "未知账号错误"),

    /**
     * 接口错误
     *
     */
    RESP_API_COMMON_ERROR(3000, ""),
    RESP_API_NO_PERMISSION(3001, "没有权限"),
    /**
     * 短信验证码相关状态码
     */
    RESP_API_SMS_SEND_LIMIT(3002, "发送频繁, 请稍后再试"),
    RESP_API_SMS_SEND_FAIL(3003, "发送失败"),
    RESP_API_SMS_SEND_EXCEPTION(3004, "验证码发送异常"),
    RESP_API_SMS_CODE_EXPIRE(3005, "无效验证码, 请重新发送"),
    RESP_API_SMS_CODE_NO_MATCHS(3006, "验证码不匹配"),
    /**
     * 项目相关状态码
     */
    RESP_API_PROJECT_NAME_EXIST(3100, "项目名称已存在"),
    RESP_API_PROJECT_NOT_EXIST(3101, "项目不存在"),
    RESP_API_PROJECT_HAS_EQUI(3102, "设备使用项目中"),
    RESP_API_PROJECT_CREATE_FAIL(3103, "项目创建失败"),
    RESP_API_PROJECT_ALTER_FAIL(3104, "项目修改失败"),
    RESP_API_PROJECT_DEL_FAIL(3105, "删除项目失败"),

    /**
     * 应用项目相关状态码
     */
    RESP_API_PROJECT_NOT_BIND_APP(3110, "项目未绑定应用"),
    RESP_API_PROJECT_BIND_APP(3111, "项目已绑定应用"),
    RESP_API_PROJECT_BIND_OTHER_APP(3112, "项目绑定其他应用"),
    RESP_API_PROJECT_BIND_APP_FAIL(3113, "项目绑定应用异常"),
    RESP_API_PROJECT_ALTER_APP_FAIL(3114, "修改项目透传状态失败"),
    RESP_API_PROJECT_UNBIND_APP_FAIL(3115, "项目解绑应用失败"),

    /**
     * 项目分组相关状态码
     */
    RESP_API_GROUP_NAME_EXIST(3200, "项目分组名称已存在"),
    RESP_API_GROUP_NOT_EXIST(3201, "项目分组不存在"),
    RESP_API_GROUP_HAS_EQUI(3202, "设备使用分组中"),
    RESP_API_GROUP_CREATE_FAIL(3203, "项目分组创建失败"),
    RESP_API_GROUP_ALTER_FAIL(3204, "项目分组修改失败"),
    RESP_API_GROUP_DEL_FAIL(3205, "删除项目分组失败"),
    /**
     * 标签类别相关状态码
     */
    RESP_API_TAG_TYPE_NAME_EXIST(3310, "标签类别名称已存在"),
    RESP_API_TAG_TYPE_NOT_EXIST(3311, "标签类别不存在"),
    RESP_API_TAG_TYPE_NUMBER_LIMIT(3312, "标签类别个数超限"),
    RESP_API_TAG_TYPE_CREATE_FAIL(3313, "标签类别创建失败"),
    RESP_API_TAG_TYPE_DEL_FAIL(3314, "删除标签类别失败"),
    /**
     * 标签相关状态码
     */
    RESP_API_TAG_NAME_EXIST(3320, "标签名称已存在"),
    RESP_API_TAG_NOT_EXIST(3321, "标签不存在"),
    RESP_API_TAG_NUMBER_LIMIT(3322, "标签个数超限"),
    RESP_API_TAG_CREATE_FAIL(3323, "标签创建失败"),
    RESP_API_TAG_DEL_FAIL(3324, "删除标签失败"),
    RESP_API_TAG_BATCH_DEL_FAIL(3325, "批量删除标签失败"),

    /**
     * 应用相关状态码
     */
    RESP_API_APP_NAME_EXIST(3400, "应用名称已存在"),
    RESP_API_APP_NOT_EXIST(3401, "应用不存在"),
    RESP_API_APP_RESET_APPKEY_FAIL(3402, "重置应用AppKey失败"),
    RESP_API_APP_RESET_APPSECRET_FAIL(3403, "重置应用AppSecret失败"),
    RESP_API_APP_ALTER_FAIL(3404, "修改应用信息失败"),
    RESP_API_APP_DEL_FAIL(3405, "删除应用失败"),
    RESP_API_APP_HAS_PROJECT(3408, "项目使用应用中"),
    RESP_API_APP_CREATE_FAIL(3409, "创建应用失败"),
    RESP_API_APP_DEL_EMQX_USER_FAIL(3406, "删除EMQX用户失败"),
    RESP_API_APP_DEL_EMQX_ACL_FAIL(3407, "删除EMQX ACL失败"),
    RESP_API_APP_ASYN_EMQX_USER_FAIL(3410, "同步EMQX用户失败"),
    RESP_API_APP_ASYN_EMQX_ACL_FAIL(3411, "同步EMQX ACL失败"),
    /**
     * 设备相关状态码
     */
    RESP_API_EQUI_NOT_EXIST(3500, "设备不存在"),
    RESP_API_EQUI_HAVE_BIND(3501, "设备SNO已注册"),
    RESP_API_EQUI_DEL_COMPANY_FAIL(3502, "删除设备与账号记录失败"),
    RESP_API_EQUI_DEL_PROJECT_FAIL(3503, "删除设备与项目记录失败"),
    RESP_API_EQUI_DEL_GROUP_FAIL(3504, "删除设备与分组记录失败"),
    RESP_API_EQUI_DEL_FAIL(3505, "删除设备记录失败"),
    RESP_API_EQUI_ADD_FAIL(3506, "添加设备记录失败"),
    RESP_API_EQUI_ADD_COMPANY_FAIL(3507, "添加设备与账号记录失败"),
    RESP_API_EQUI_ADD_PROJECT_FAIL(3508, "添加设备与项目记录失败"),
    RESP_API_EQUI_ADD_GROUP_FAIL(3509, "添加设备与分组记录失败"),
    RESP_API_EQUI_NOT_BIND_PROJECT(3510, "设备未绑定项目"),

    RESP_API_DTU_SERVER_OFFLINE(3600, "DTU服务离线"),

    RESP_API_ERROR_UNKNOWN(3999, "接口异常");


    /**
     * apiRespCode值
     */
    private Integer code;

    /**
     * apiResp Error描述
     */
    private String message;

    /**
     * 私有构造方法
     *
     * @param code
     */
    RespCodeType(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}
