package com.hp.message.enums;

import com.hp.message.exception.EnumException;

/**
 * @author 尚肖磊
 *  2021-04-16 9:43
 *  rocket通信tag枚举类
 */
public enum MqMsgType {

    /**
     * Equi登录相关消息
     */
    MQ_EQUI_LOGIN_REQ(10,"equi_login_req", "Equi服务 -> Message服务 设备登录请求"),
    MQ_EQUI_LOGIN_RESP(11, "equi_login_resp", "Message服务 -> Equi服务 设备登录响应"),
    MQ_EQUI_LOGIN_NOTIFY(13, "equi_login_notify", "Message服务 -> Emqx服务 设备上线通知"),
    EMQX_EQUI_LOGIN_NOTIFY(12,"equi_login_notify", "Message服务 设备上线通知"),

    /**
     * Equi登出相关消息
     */
    MQ_EQUI_LOGOUT_REQ(20,"equi_logout_req", "Equi服务 -> Message服务 设备登出请求"),
    MQ_EQUI_LOGOUT_RESP(21,"equi_logout_resp", "Message服务 -> Equi服务 设备登出响应"),
    MQ_EQUI_LOGOUT_NOTIFY(23,"equi_logout_notify", "Message服务 -> Emqx服务 设备离线通知"),
    EMQX_EQUI_LOGOUT_NOTIFY(22,"equi_logout_notify", "Message服务 设备离线通知"),

    /**
     * Equi上报数据 到 Message服务
     */
    MQ_EQUI_UPLOAD_DATA_REQ(30,"equi_upload_data_req", "Equi服务 -> Message服务 设备上报数据请求"),
    MQ_EQUI_UPLOAD_DATA_RESP(31,"equi_upload_data_resp", "Message服务 -> Equi服务 设备上报数据响应"),

    /**
     * Message上报数据 到 Emqx服务
     */
    MQ_EMQX_UPLOAD_DATA_REQ(120,"msg_upload_data_req", "Message服务 -> Emqx服务 上报数据请求"),
    MQ_EMQX_UPLOAD_DATA_RESP(121,"msg_upload_data_resp", "Emqx服务 -> Message服务 上报数据响应"),

    /**
     * Emqx服务 推送消息到SDK相关消息
     */
    EMQX_SDK_UPLOAD_DATA_REQ(40,"emqx_upload_data_req", "Emqx服务 -> SDK服务 推送设备上报数据请求"),
    EMQX_SDK_UPLOAD_DATA_RESP(41,"emqx_upload_data_resp", "SDK服务 -> Message服务 推送设备上报数据响应"),

    /**
     * Message服务 推送消息到Equi服务
     */
    MQ_MESSAGE_PUSH_DATA_REQ(50,"msg_push_data_req", "Message服务 -> Equi服务 推送消息到设备请求"),
    MQ_MESSAGE_PUSH_DATA_RESP(51,"msg_push_data_resp", "Equi服务 -> Message服务 推送消息到设备响应"),

    /**
     * Message服务 推送消息到Equi服务
     */
    MQ_EMQX_PUSH_DATA_REQ(130,"emqx_push_data_req", "Emqx服务 -> Equi服务 推送消息到设备请求"),
    MQ_EMQX_PUSH_DATA_RESP(131,"emqx_push_data_resp", "Equi服务 -> Emqx服务 推送消息到设备响应"),

    /**
     * SDK服务 推送消息到Emqx服务
     */
    EMQX_SDK_PUSH_DATA_REQ(60,"sdk_push_data_req", "SDK服务 下发数据请求"),
    EMQX_SDK_PUSH_DATA_RESP(61,"sdk_push_data_resp", "SDK服务 下发数据响应"),

    /**
     * 云服务 下发设备升级任务相关消息
     */
    MQ_CLOUD_PUSH_EQUI_UPGRADE_REQ(80,"cloud_push_equi_upgrade_req", "云服务 下发设备升级消息请求"),
    MQ_CLOUD_PUSH_EQUI_UPGRADE_RESP(81,"cloud_push_equi_upgrade_resp", "云服务 下发设备升级消息响应"),

    /**
     * 调度服务 调度任务相关消息
     */
    MQ_SCHEDULER_PUSH_JOB_REQ(90,"scheduler_push_job_req", "调度服务 发送调度消息请求"),
    MQ_SCHEDULER_PUSH_JOB_RESP(91,"scheduler_push_job_resp", "调度服务 发送调度消息响应"),

    /**
     * SDK服务 上线下线相关消息
     */
    EMQX_SDK_ONLINE(100,"sdk_online", "SDK服务 上线消息"),
    EMQX_SDK_OFFLINE(101,"sdk_offline", "SDK服务 离线消息"),

    /**
     * 动态变更emqxClient相关消息
     */
    MQ_EMQX_CLIENT_ADD_REQ(110,"emqx_client_add_req", "App服务 -> Message服务 增加emqxClient消息请求"),
    MQ_EMQX_CLIENT_ADD_RESP(111,"emqx_client_add_resp", "Message服务 -> App服务 增加emqxClient消息响应"),
    MQ_EMQX_CLIENT_DEL_REQ(112,"emqx_client_del_req", "App服务 -> Message服务 移除emqxClient消息请求"),
    MQ_EMQX_CLIENT_DEL_RESP(113,"emqx_client_del_resp", "Message服务 -> App服务 移除emqxClient消息响应");

    /**
     * 消息类型Id
     */
    private Integer msgTypeId;

    /**
     * 消息类型关联tag
     */
    private String msgTag;

    /**
     * 消息类型描述
     */
    private String msgTypeDesc;

    /**
     * 内部构造方法
     *
     * @param msgTypeId   消息类型id
     * @param msgTag      消息关联tag
     * @param msgTypeDesc 消息类型描述
     */
    MqMsgType(Integer msgTypeId, String msgTag, String msgTypeDesc) {
        this.msgTypeId = msgTypeId;
        this.msgTag = msgTag;
        this.msgTypeDesc = msgTypeDesc;
    }

    public Integer getMsgTypeId() {
        return msgTypeId;
    }

    public String getMsgTag() {
        return msgTag;
    }

    public String getMsgTypeDesc() {
        return msgTypeDesc;
    }

    /**
     * 获取rocket消息类型对象
     *
     * @param msgTypeId 消息类型id
     * @return
     */
    public static MqMsgType getRocketMsgTypeById(Integer msgTypeId) throws EnumException {
        for (MqMsgType typeEnum : MqMsgType.values()) {
            if (typeEnum.getMsgTypeId().equals(msgTypeId)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported mq msgType : " + msgTypeId);
    }

    public static MqMsgType getRocketMsgTypeByTag(String msgTag) throws EnumException {
        for (MqMsgType typeEnum : MqMsgType.values()) {
            if (typeEnum.getMsgTag().equals(msgTag)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported mq msgType : " + msgTag);
    }

}
