package com.hp.message.enums;

import com.hp.message.exception.EnumException;

/**
 * @author 尚肖磊
 *  2021-04-27 10:30
 *  消息处理结果枚举类
 */
public enum MqMsgResultType {

    /********************通用处理结果****************************/
    /**
     * 未知状态
     */
    UNKNOWN(0, "未知状态"),
    /**
     * 处理成功
     */
    SUCCESS(1, "成功"),
    TIMEOUT(2, "超时未响应"),
    FORMAT_EXCEPTION(3, "格式异常"),

    /**
     * 设备未注册
     */
    EQUI_NOT_EXIST(11, "设备不存在"),

    /**
     * 设备离线
     */
    EQUI_OFFLINE(12, "设备离线"),

    /**
     * 设备未绑定App
     */
    EQUI_NOT_BIND_APP(13, "设备未绑定App"),

    /**
     * 设备绑定其他App
     */
    EQUI_BIND_OTHER_APP(14, "设备绑定其他App"),

    /**
     * 项目透传状态关闭
     */
    PROJECT_TRANSFER_CLOSE(15, "项目透传状态关闭"),

    /**
     * 消息发送异常
     */
    MSG_SEND_EXCEPTION(16, "发送异常"),


    /********************设备登录结果***************************/
    /**
     * 登录方式未识别
     */
    SNO_TYPE_NOT_SUPPORT(101, "登录方式未识别"),

    /**
     * 设备通讯密码不匹配
     */
    CLOUD_PASSWORD_NOT_MATCH(102, "设备通讯密码不匹配"),

    /**
     * 消息缓存失败
     */
    MSG_SAVE_FAIL(999, "消息缓存失败");

    /**
     * 处理结果Code
     */
    private Integer resultCode;

    /**
     * 处理结果描述
     */
    private String resultDesc;


    MqMsgResultType(Integer resultCode, String resultDesc) {
        this.resultCode = resultCode;
        this.resultDesc = resultDesc;
    }

    public Integer getResultCode() {
        return resultCode;
    }

    public String getResultDesc() {
        return resultDesc;
    }

    public static MqMsgResultType getMsgResultTypeByCode(Integer resultCode) throws EnumException {
        for (MqMsgResultType typeEnum : MqMsgResultType.values()) {
            if (typeEnum.getResultCode().equals(resultCode)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported msgResultType : " + resultCode);
    }

}
