package com.hp.message.enums;

import com.hp.message.exception.EnumException;

/**
 * @author 尚肖磊
 *  2021-04-27 10:20
 *  消息处理进度枚举类
 */
public enum MqMsgProgressedType {

    /**
     * 消息接收完成
     */
    RECEIVE_FINISH(0, "消息接收完成"),

    /**
     * 消息处理完成
     */
    HANLDER_FINISH(1, "消息处理完成");

    /**
     * 处理进度code
     */
    private Integer progressCode;

    /**
     * 处理进度描述
     */
    private String progressDesc;


    MqMsgProgressedType(Integer progressCode, String progressDesc) {
        this.progressCode = progressCode;
        this.progressDesc = progressDesc;
    }

    public Integer getProgressCode() {
        return progressCode;
    }

    public String getProgressDesc() {
        return progressDesc;
    }

    public static MqMsgProgressedType getEquiSnoTypeById(Integer progressCode) throws EnumException {
        for (MqMsgProgressedType typeEnum : MqMsgProgressedType.values()) {
            if (typeEnum.getProgressCode().equals(progressCode)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported msgProgressType : " + progressCode);
    }

}
