package com.hp.message.enums;

import com.hp.message.exception.EnumException;

/**
 * @author 尚肖磊
 *  2021-04-27 9:59
 *  设备离线方式枚举类
 */
public enum EquiLogoutType {

    /**
     * 设备主动退出
     */
    LOGOUT_1(1, "设备主动请求退出", true),

    /**
     * 重复登录，被迫退出
     */
    LOGOUT_2(2, "重复登录,被迫退出", false),

    /**
     * 心跳超时退出
     */
    LOGOUT_3(3, "心跳超时退出", false),

    /**
     * 系统异常退出
     */
    LOGOUT_4(4, "异常断开退出", false);


    /**
     * 登出code
     */
    private Integer code;

    /**
     * 登出code描述
     */
    private String codeDesc;

    /**
     * 是否需要响应
     */
    private Boolean needResp;

    EquiLogoutType(Integer code, String codeDesc, Boolean needResp) {
        this.code = code;
        this.codeDesc = codeDesc;
        this.needResp = needResp;
    }

    public Integer getCode() {
        return code;
    }

    public String getCodeDesc() {
        return codeDesc;
    }

    public Boolean getNeedResp() {
        return needResp;
    }

    public static EquiLogoutType getLogoutTypeByCode(Integer logoutCode) throws EnumException {
        for (EquiLogoutType typeEnum : EquiLogoutType.values()) {
            if (typeEnum.getCode().equals(logoutCode)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported LogoutType : " + logoutCode);
    }
}
