package com.hp.message.enums;

import com.hp.message.exception.EnumException;

/**
 * @author 尚肖磊
 *  2021-04-23 13:36
 *  emqx主题通道枚举定义
 */
public enum EmqxTopicType {

    /**
     * 发布消息通道
     */
    EMQX_APP_PUH_CHANNEL(5, "App发布渠道"),

    /**
     * 接收消息通道
     */
    EMQX_APP_SUB_CHANNEL(6, "App订阅渠道");


    /**
     * 通道Id
     */
    private Integer channelId;

    /**
     * 通道描述
     */
    private String channelDesc;


    EmqxTopicType(Integer channelId, String channelDesc) {
        this.channelId = channelId;
        this.channelDesc = channelDesc;
    }

    public Integer getChannelId() {
        return channelId;
    }

    public String getChannelDesc() {
        return channelDesc;
    }

    /**
     * 获取emqx 通信渠道枚举
     *
     * @param channelId emqx通信渠道id
     * @return
     */
    public static EmqxTopicType getEmqxChannelTypeByChannelId(Integer channelId) throws EnumException {
        for (EmqxTopicType typeEnum : EmqxTopicType.values()) {
            if (typeEnum.getChannelId().equals(channelId)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported EmqxChannelType: " + channelId);
    }
}
