package com.hp.message.enums;

/**
 * @author 尚肖磊
 *  2021-04-23 16:16
 *  emqx消息Qos枚举定义
 */
public enum EmqxQosType {

    /**
     * 最多1次消息类型
     */
    QOS_0(0, "消息最多传递一次"),

    /**
     * 至少1次消息类型
     */
    QOS_1(1, "消息传递至少一次"),

    /**
     * 仅一次消息类型
     */
    QOS_2(2, "消息仅传送一次");

    /**
     * 消息质量等级
     */
    Integer qos;

    /**
     * 消息质量等级描述
     */
    String qosDesc;

    EmqxQosType(Integer qos, String qosDesc) {
        this.qos = qos;
        this.qosDesc = qosDesc;
    }

    public Integer getQos() {
        return qos;
    }

    public String getQosDesc() {
        return qosDesc;
    }

}
