package com.hp.message.enums;

import com.hp.message.exception.EnumException;

/**
 * @author 尚肖磊
 *  2021-04-27 11:14
 *  App主题通道枚举定义
 */
public enum AppChannelType {

    /**
     * 设备消息通道
     */
    APP_ID_CHANNEL(1, "App设备通道"),

    /**
     * 项目消息通道
     */
    APP_PROJECT_CHANNEL(2, "App项目通道"),

    /**
     * 分组消息通道
     */
    APP_GROUP_CHANNEL(3, "App项目分组通道"),

    /**
     * 应用消息通道
     */
    APP_CHANNEL(4, "App应用通道");

    /**
     * 通道Id
     */
    private Integer channelId;

    /**
     * 通道描述
     */
    private String channelDesc;


    AppChannelType(Integer channelId, String channelDesc) {
        this.channelId = channelId;
        this.channelDesc = channelDesc;
    }

    public Integer getChannelId() {
        return channelId;
    }

    public String getChannelDesc() {
        return channelDesc;
    }

    /**
     * 获取App 通信渠道枚举
     *
     * @param channelId App通信渠道id
     * @return
     */
    public static AppChannelType getAppChannelTypeByChannelId(Integer channelId) throws EnumException {
        for (AppChannelType typeEnum : AppChannelType.values()) {
            if (typeEnum.getChannelId().equals(channelId)) {
                return typeEnum;
            }
        }
        throw new EnumException("unsupported AppChannelType: " + channelId);
    }

}
