package com.hp.message.domain.param;

import lombok.Data;

/**
 * @author 尚肖磊
 *  2021-05-17 16:37
 *  添加设备参数封装类
 */
@Data
public class AddEquiParam {

    /**
     * 注册方式 01 出厂SNO(设备sno + imei) 02 非出厂SNO(sno + 通讯密码)
     */
    private String addEquiType;

    /**
     * 设备名称(允许重名)
     */
    private String equiName;

    /**
     * 项目id
     */
    private Integer projectId;

    /**
     * 项目分组id
     */
    private Integer groupId;

    /**
     * 设备sno (注册方式1时 必传)
     */
    private String equiSno;

    /**
     * 设备imei/mac/nid等硬件标识 (注册方式1时 必传)
     */
    private String equiImei;

    /**
     * 通讯密码模式 1 账号通讯密码 2 自定义通讯密码 (注册方式2时 必传)
     */
    private Integer passCreateType;

    /**
     * 自定义通讯密码(8位) (通讯密码模式2时 必传)
     */
    private String writePassword;

}
