package com.hp.message.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.primitives.Bytes;
import com.hp.message.enums.EquiLogoutType;
import com.hp.message.enums.MqMsgProgressedType;
import com.hp.message.enums.MqMsgResultType;
import com.hp.message.enums.MqMsgType;
import com.hp.message.utils.UuidUtil;
import org.springframework.util.ObjectUtils;
import java.io.Serializable;
import java.util.List;

/**
 * @author 尚肖磊
 *  2021-04-24 10:42
 *  emqx消息Req类
 */
public class EmqxDataMsg implements Serializable {


    /**
     * appId : 16190714665936
     * msgId : 5362eb3ebe5849b899b2c0c6a72b9621
     * equiSno : 00100002021000000005
     * msgType : 0
     * logoutCode : 1
     * transferData : 7B03001632313030303030303030350ABD49EB16917B
     * progressCode : 2
     * handlerResultCode : 10
     */
    @JSONField(name = "appId")
    private String appId;
    @JSONField(name = "handleId")
    private Integer handleId;
    @JSONField(name = "msgId")
    private String msgId;
    @JSONField(name = "equiSno")
    private String equiSno;
    @JSONField(name = "msgType")
    private MqMsgType msgType;
    @JSONField(name = "logoutCode")
    private EquiLogoutType logoutCode;
    @JSONField(name = "transferData")
    private List<Byte> transferData;
    @JSONField(name = "progressCode")
    private MqMsgProgressedType progressCode;
    @JSONField(name = "handlerResultCode")
    private MqMsgResultType handlerResultCode;

    /**
     * respConfig : {"respTopic":"1/6/16190714665936/1/00100002021000000005","respTimeout":"10"}
     */
    @JSONField(name = "respConfig")
    private RespConfigBean respConfig;

    public EmqxDataMsg() {
        this.msgId = UuidUtil.getUuid(false, true);
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Integer getHandleId() {
        return handleId;
    }

    public void setHandleId(Integer handleId) {
        this.handleId = handleId;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getEquiSno() {
        return equiSno;
    }

    public void setEquiSno(String equiSno) {
        this.equiSno = equiSno;
    }

    public MqMsgType getMsgType() {
        return msgType;
    }

    public void setMsgType(MqMsgType msgType) {
        this.msgType = msgType;
    }

    public EquiLogoutType getLogoutCode() {
        return logoutCode;
    }

    public void setLogoutCode(EquiLogoutType logoutCode) {
        this.logoutCode = logoutCode;
    }

    public List<Byte> getTransferData() {
        return transferData;
    }

    public void setTransferData(List<Byte> transferData) {
        this.transferData = transferData;
    }

    public void setTransferData(byte[] transferData) {
        this.transferData = Bytes.asList(transferData);
    }

    public MqMsgProgressedType getProgressCode() {
        return progressCode;
    }

    public void setProgressCode(MqMsgProgressedType progressCode) {
        this.progressCode = progressCode;
    }

    public MqMsgResultType getHandlerResultCode() {
        return handlerResultCode;
    }

    public void setHandlerResultCode(MqMsgResultType handlerResultCode) {
        this.handlerResultCode = handlerResultCode;
    }

    public boolean getNeedResp() {
        if (ObjectUtils.isEmpty(respConfig)) {
            return false;
        }
        return true;
    }

    public RespConfigBean getRespConfig() {
        return respConfig;
    }

    public void setRespConfig(RespConfigBean respConfig) {
        this.respConfig = respConfig;
    }

    public static class RespConfigBean {
        /**
         * respTopic : 1/6/16190714665936/1/00100002021000000005
         * respTimeout : 10
         */

        @JSONField(name = "respTopic")
        private String respTopic;
        @JSONField(name = "respTimeout")
        private Integer respTimeout;

        public String getRespTopic() {
            return respTopic;
        }

        public void setRespTopic(String respTopic) {
            this.respTopic = respTopic;
        }

        public Integer getRespTimeout() {
            return respTimeout;
        }

        public void setRespTimeout(Integer respTimeout) {
            this.respTimeout = respTimeout;
        }
    }

}
