package com.hp.message.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.hp.message.enums.RespCodeType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author 尚肖磊
 *  2021-03-27 15:38
 *  接口返回 json结果基础类
 */

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiResp<T> implements Serializable {

    /**
     * 响应code值
     */
    private Integer code;

    /**
     * 结果描述
     */
    private String message;

    /**
     * 返回具体数据对象
     */
    private T data;

    /**
     * 请求 是否成功
     *
     * @return
     */
    @JSONField(serialize = false)
    public boolean isSuccess(){
        return code.equals(RespCodeType.RESP_SUCCESS);
    }

}
