package com.hp.message.config;

import com.hp.message.interceptor.ApiSignInterceptor;
import com.hp.message.property.AppProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author 尚肖磊
 *  2021-06-22 15:13
 *  app相关自动配置类
 */
@Slf4j
@Configuration
@ComponentScan("com.hp.message.property")
@ComponentScan("com.hp.message.interfaces")
@ComponentScan("com.hp.message.service.common")
@EnableConfigurationProperties(value = AppProperty.class)
public class AppAutoConfigure {

    /**
     * 华普app相关配置类
     */
    private final AppProperty appProperty;

    public AppAutoConfigure(AppProperty appProperty) {
        if (appProperty == null){
            log.error( "{} config lost", AppProperty.DEFAULT_PREFIX);
        }
        this.appProperty = appProperty;
    }

    /**
     * 配置api统一签名 拦截器对象
     *
     * @return {@link ApiSignInterceptor}
     */
    @Bean
    @ConditionalOnMissingBean
    public ApiSignInterceptor apiSignInterceptor() {
        ApiSignInterceptor apiSignInterceptor = new ApiSignInterceptor(appProperty);
        return apiSignInterceptor;
    }

}
