package com.hp.message.config;

import com.hp.message.interfaces.IRetrofitApiService;
import com.hp.message.property.ApiProperty;
import com.hp.message.interfaces.IApiService;
import com.hp.message.service.ApiService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author 尚肖磊
 *  2021-06-18 16:01
 *  api服务自动配置类
 */
@Slf4j
@Configuration
@AutoConfigureAfter(AppAutoConfigure.class)
@EnableConfigurationProperties(value = ApiProperty.class)
public class ApiAutoConfigure {

    /**
     * 华普api接口配置类
     */
    private final ApiProperty apiProperty;

    @Autowired
    private IRetrofitApiService retrofitApiService;

    public ApiAutoConfigure(ApiProperty apiProperty) {
        if (apiProperty == null){
            log.error( "{} config lost", ApiProperty.DEFAULT_PREFIX);
        }
        this.apiProperty = apiProperty;
    }

    @Bean
    @ConditionalOnMissingBean
    public IApiService createApiService(){
        return new ApiService(retrofitApiService);
    }

}
