package com.hp.message.annotation;

import com.github.lianjiatech.retrofit.spring.boot.annotation.InterceptMark;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import com.hp.message.interceptor.ApiSignInterceptor;

import java.lang.annotation.*;

/**
 * @author 尚肖磊
 * 2021-06-02 16:18
 * api请求统一签名注解
 */

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented

@InterceptMark
public @interface ApiSign {

    /**
     * 拦截器匹配路径
     *
     * @return 返回
     */
    String[] include() default {"/**"};

    /**
     * 拦截器排除匹配，排除指定路径拦截
     *
     * @return 返回
     */
    String[] exclude() default {};

    /**
     * 处理该注解的拦截器类
     * 优先从spring容器获取对应的Bean，如果获取不到，则使用反射创建一个！
     *
     * @return 返回
     */
    Class<? extends BasePathMatchInterceptor> handler() default ApiSignInterceptor.class;

}
