/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserSortBy;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

@Schema(description="The results of a request to retrieve a list of users")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectoryId", "users", "total", "filter", "sortBy", "sortDirection", "pageIndex", "pageSize"})
public class Users
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The optional filter that was applied to the users")
    @JsonProperty
    private String filter;
    @Schema(description="The optional page index")
    @JsonProperty
    private Integer pageIndex;
    @Schema(description="The optional page size")
    @JsonProperty
    private Integer pageSize;
    @Schema(description="The optional method used to sort the users e.g. by name")
    @JsonProperty
    private UserSortBy sortBy;
    @Schema(description="The optional sort direction that was applied to the users")
    @JsonProperty
    private SortDirection sortDirection;
    @Schema(description="The total number of users", required=true)
    @JsonProperty(required=true)
    private long total;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory the users are associated with", required=true)
    @JsonProperty(required=true)
    private UUID userDirectoryId;
    @Schema(description="The users", required=true)
    @JsonProperty(required=true)
    private List<User> users;

    public Users() {
    }

    public Users(UUID userDirectoryId, List<User> users, long total, String filter, UserSortBy sortBy, SortDirection sortDirection, Integer pageIndex, Integer pageSize) {
        this.userDirectoryId = userDirectoryId;
        this.users = users;
        this.total = total;
        this.filter = filter;
        this.sortBy = sortBy;
        this.sortDirection = sortDirection;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public UserSortBy getSortBy() {
        return this.sortBy;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public Long getTotal() {
        return this.total;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }

    public List<User> getUsers() {
        return this.users;
    }
}

