/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The user status")
public enum UserStatus {
    INACTIVE("inactive", "Inactive"),
    ACTIVE("active", "Active"),
    LOCKED("locked", "Locked"),
    EXPIRED("expired", "Expired");

    private final String code;
    private final String description;

    private UserStatus(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static int toNumericCode(UserStatus userStatus) {
        switch (userStatus) {
            case ACTIVE: {
                return 1;
            }
            case INACTIVE: {
                return 2;
            }
            case LOCKED: {
                return 3;
            }
            case EXPIRED: {
                return 4;
            }
        }
        throw new RuntimeException("Failed to determine the numeric code for the user status (" + userStatus.code() + ")");
    }

    public static UserStatus fromNumericCode(int numericCode) {
        switch (numericCode) {
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return INACTIVE;
            }
            case 3: {
                return LOCKED;
            }
            case 4: {
                return EXPIRED;
            }
        }
        throw new RuntimeException("Failed to determine the user status for the numeric database code (" + numericCode + ")");
    }

    @JsonCreator
    public static UserStatus fromCode(String code) {
        switch (code) {
            case "inactive": {
                return INACTIVE;
            }
            case "active": {
                return ACTIVE;
            }
            case "locked": {
                return LOCKED;
            }
            case "expired": {
                return EXPIRED;
            }
        }
        throw new RuntimeException("Failed to determine the user status with the invalid code (" + code + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

