/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The method used to sort the list of users")
public enum UserSortBy {
    NAME("name", "Sort By Name"),
    PREFERRED_NAME("preferred_name", "Sort By Preferred Name"),
    USERNAME("username", "Sort By Username");

    private final String code;
    private final String description;

    private UserSortBy(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonCreator
    public static UserSortBy fromCode(String code) {
        switch (code) {
            case "name": {
                return NAME;
            }
            case "preferred_name": {
                return PREFERRED_NAME;
            }
            case "username": {
                return USERNAME;
            }
        }
        throw new RuntimeException("Failed to determine the user sort by with the invalid code (" + code + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }
}

