/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Group;
import africa.absa.inception.security.User;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.query.QueryByExampleExecutor;

public interface UserRepository
extends JpaRepository<User, UUID>,
QueryByExampleExecutor<User> {
    @Modifying
    @Query(value="update User u set u.password = :password, u.passwordAttempts = :passwordAttempts, u.passwordExpiry = :passwordExpiry where u.id = :userId")
    public void changePassword(@Param(value="userId") UUID var1, @Param(value="password") String var2, @Param(value="passwordAttempts") int var3, @Param(value="passwordExpiry") Optional<LocalDateTime> var4);

    public long countByUserDirectoryId(UUID var1);

    @Query(value="select count(u.id) from User u where ((lower(u.username) like lower(:filter)) or (lower(u.name) like lower(:filter))) and u.userDirectoryId = :userDirectoryId")
    public long countFiltered(@Param(value="userDirectoryId") UUID var1, @Param(value="filter") String var2);

    @Modifying
    @Query(value="delete from User u where u.id = :userId")
    public void deleteById(@Param(value="userId") UUID var1);

    public boolean existsByUserDirectoryIdAndUsernameIgnoreCase(UUID var1, String var2);

    public List<User> findByUserDirectoryId(UUID var1);

    public Page<User> findByUserDirectoryId(UUID var1, Pageable var2);

    public Optional<User> findByUserDirectoryIdAndUsernameIgnoreCase(UUID var1, String var2);

    @Query(value="select u from User u where ((lower(u.username) like lower(:filter)) or (lower(u.name) like lower(:filter))) and u.userDirectoryId = :userDirectoryId")
    public Page<User> findFiltered(@Param(value="userDirectoryId") UUID var1, @Param(value="filter") String var2, Pageable var3);

    @Query(value="select f.code from User u join u.groups as g join g.roles as r join r.functions as f where u.id = :userId")
    public List<String> getFunctionCodesByUserId(@Param(value="userId") UUID var1);

    @Query(value="select g.name from User u join u.groups as g where u.id = :userId")
    public List<String> getGroupNamesByUserId(@Param(value="userId") UUID var1);

    @Query(value="select g from User u join u.groups as g where u.id = :userId")
    public List<Group> getGroupsByUserId(@Param(value="userId") UUID var1);

    @Query(value="select u.id from User u where u.userDirectoryId = :userDirectoryId and lower(u.username) like lower(:username)")
    public Optional<UUID> getIdByUserDirectoryIdAndUsernameIgnoreCase(@Param(value="userDirectoryId") UUID var1, @Param(value="username") String var2);

    @Query(value="select u.name from User u where ((lower(u.username) = lower(:username)) and u.userDirectoryId = :userDirectoryId)")
    public Optional<String> getNameByUserDirectoryIdAndUsernameIgnoreCase(UUID var1, String var2);

    @Query(value="select password from security.users_password_history where user_id = :userId and changed > :after", nativeQuery=true)
    public List<String> getPasswordHistory(@Param(value="userId") UUID var1, @Param(value="after") LocalDateTime var2);

    @Query(value="select r.code from User u join u.groups as g join g.roles as r where u.id = :userId")
    public List<String> getRoleCodesByUserId(@Param(value="userId") UUID var1);

    @Query(value="select u.userDirectoryId from User u where lower(u.username) = lower(:username)")
    public Optional<UUID> getUserDirectoryIdByUsernameIgnoreCase(@Param(value="username") String var1);

    @Modifying
    @Query(value="update User u set u.passwordAttempts = u.passwordAttempts + 1 where u.id = :userId")
    public void incrementPasswordAttempts(@Param(value="userId") UUID var1);

    @Query(value="select case when (count(u.id) > 0) then true else false end from User u join u.groups as g where u.id = :userId and g.id = :groupId")
    public boolean isUserInGroup(@Param(value="userId") UUID var1, @Param(value="groupId") UUID var2);

    @Modifying
    @Query(value="update User u set u.password = :password, u.passwordAttempts = 0, u.passwordExpiry = :passwordExpiry where u.id = :userId")
    public void resetPassword(@Param(value="userId") UUID var1, @Param(value="password") String var2, @Param(value="passwordExpiry") LocalDateTime var3);

    @Modifying
    @Query(value="delete from security.users_password_history where user_id = :userId", nativeQuery=true)
    public void resetPasswordHistory(@Param(value="userId") UUID var1);

    @Modifying
    @Query(value="insert into security.users_password_history(user_id, changed, password) values (:userId, current_timestamp, :password)", nativeQuery=true)
    public void savePasswordInPasswordHistory(@Param(value="userId") UUID var1, @Param(value="password") String var2);
}

