/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A user directory type")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"code", "name", "userDirectoryClassName"})
@Entity
@Table(schema="security", name="user_directory_types")
public class UserDirectoryType
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The code for the user directory type", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Id
    @Column(name="code", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String code;
    @Schema(description="The name of the user directory type", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @JsonIgnore
    @Transient
    private transient Class userDirectoryClass;
    @Schema(description="The fully qualified name of the Java class that implements the user directory type", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=1000)
    @Column(name="user_directory_class", length=1000, nullable=false)
    private @NotNull @Size(min=1, max=1000) String userDirectoryClassName;

    public UserDirectoryType() {
    }

    UserDirectoryType(String code, String name, String userDirectoryClassName) {
        this.code = code;
        this.name = name;
        this.userDirectoryClassName = userDirectoryClassName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserDirectoryType other = (UserDirectoryType)object;
        return Objects.equals(this.code, other.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.code == null ? 0 : this.code.hashCode();
    }

    String getUserDirectoryClassName() {
        return this.userDirectoryClassName;
    }
}

