/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Tenant;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A user directory summary")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "type", "name"})
@Entity
@Table(schema="security", name="user_directories")
public class UserDirectorySummary
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.REFRESH})
    @JoinTable(schema="security", name="user_directory_to_tenant_map", joinColumns={@JoinColumn(name="user_directory_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="tenant_id", referencedColumnName="id")})
    private final Set<Tenant> tenants = new HashSet<Tenant>();
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Id
    @Column(name="id", nullable=false)
    private UUID id;
    @Schema(description="The name of the user directory", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @Schema(description="The code for the user directory type", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="type", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String type;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserDirectorySummary other = (UserDirectorySummary)object;
        return Objects.equals(this.id, other.id);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }
}

