/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.security.UserDirectorySummary;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.List;

@Schema(description="The results of a request to retrieve a list of user directory summaries")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectorySummaries", "total", "filter", "sortDirection", "pageIndex", "pageSize"})
public class UserDirectorySummaries
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The optional filter that was applied to the user directory summaries")
    @JsonProperty
    private String filter;
    @Schema(description="The optional page index")
    @JsonProperty
    private Integer pageIndex;
    @Schema(description="The optional page size")
    @JsonProperty
    private Integer pageSize;
    @Schema(description="The optional sort direction that was applied to the user directory summaries")
    @JsonProperty
    private SortDirection sortDirection;
    @Schema(description="The total number of user directory summaries", required=true)
    @JsonProperty(required=true)
    private long total;
    @Schema(description="The user directory summaries", required=true)
    @JsonProperty(required=true)
    private List<UserDirectorySummary> userDirectorySummaries;

    public UserDirectorySummaries() {
    }

    public UserDirectorySummaries(List<UserDirectorySummary> userDirectorySummaries, long total, String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) {
        this.userDirectorySummaries = userDirectorySummaries;
        this.total = total;
        this.filter = filter;
        this.sortDirection = sortDirection;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public Long getTotal() {
        return this.total;
    }

    public List<UserDirectorySummary> getUserDirectorySummaries() {
        return this.userDirectorySummaries;
    }
}

