/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.UserDirectory;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface UserDirectoryRepository
extends JpaRepository<UserDirectory, UUID> {
    public long countByNameContainingIgnoreCase(String var1);

    @Modifying
    @Query(value="delete from UserDirectory ud where ud.id = :userDirectoryId")
    public void deleteById(@Param(value="userDirectoryId") UUID var1);

    public boolean existsByNameIgnoreCase(String var1);

    public Page<UserDirectory> findAllByOrderByNameAsc(Pageable var1);

    public Page<UserDirectory> findAllByOrderByNameDesc(Pageable var1);

    @Query(value="select ud from UserDirectory ud join ud.tenants as o where o.id = :tenantId")
    public List<UserDirectory> findAllByTenantId(@Param(value="tenantId") UUID var1);

    public Page<UserDirectory> findByNameContainingIgnoreCaseOrderByNameAsc(String var1, Pageable var2);

    public Page<UserDirectory> findByNameContainingIgnoreCaseOrderByNameDesc(String var1, Pageable var2);

    @Query(value="select ud.name from UserDirectory ud where ud.id = :userDirectoryId")
    public Optional<String> getNameById(@Param(value="userDirectoryId") UUID var1);

    @Query(value="select o.id from Tenant o join o.userDirectories as ud where ud.id = :userDirectoryId")
    public List<UUID> getTenantIdsById(@Param(value="userDirectoryId") UUID var1);

    @Query(value="select ud.type from UserDirectory ud where ud.id = :userDirectoryId")
    public Optional<String> getTypeForUserDirectoryById(@Param(value="userDirectoryId") UUID var1);
}

