/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.util.Base64Util;
import africa.absa.inception.core.util.BinaryBuffer;
import africa.absa.inception.security.UserDirectoryParameterException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A name-value pair parameter for a user directory")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "value"})
public class UserDirectoryParameter
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The name of the user directory parameter", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String name;
    @Schema(description="The value for the user directory parameter", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String value;

    public UserDirectoryParameter() {
    }

    public UserDirectoryParameter(String name, BigDecimal value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public UserDirectoryParameter(String name, BinaryBuffer value) {
        this.name = name;
        this.value = Base64Util.encodeBytes((byte[])value.getData());
    }

    public UserDirectoryParameter(String name, byte[] value) {
        this.name = name;
        this.value = Base64Util.encodeBytes((byte[])value);
    }

    public UserDirectoryParameter(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public UserDirectoryParameter(String name, long value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public UserDirectoryParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static boolean contains(List<UserDirectoryParameter> parameters, String name) {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getBinaryValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            try {
                return Base64Util.decode((String)parameter.value);
            }
            catch (Throwable e) {
                throw new UserDirectoryParameterException(String.format("Failed to retrieve the binary value for the user directory parameter (%s)", parameter.name));
            }
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the binary value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static boolean getBooleanValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            try {
                return Boolean.parseBoolean(parameter.value);
            }
            catch (Throwable e) {
                throw new UserDirectoryParameterException(String.format("Failed to retrieve the boolean value for the user directory parameter (%s)", parameter.name));
            }
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the boolean value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static BigDecimal getDecimalValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            try {
                return new BigDecimal(parameter.value);
            }
            catch (Throwable e) {
                throw new UserDirectoryParameterException(String.format("Failed to retrieve the decimal value for the user directory parameter (%s)", parameter.name));
            }
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the decimal value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static double getDoubleValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            try {
                return Double.parseDouble(parameter.value);
            }
            catch (Throwable e) {
                throw new UserDirectoryParameterException(String.format("Failed to retrieve the double value for the user directory parameter (%s)", parameter.name));
            }
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the double value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static int getIntegerValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            try {
                return Integer.parseInt(parameter.value);
            }
            catch (Throwable e) {
                throw new UserDirectoryParameterException(String.format("Failed to retrieve the integer value for the user directory parameter (%s)", parameter.name));
            }
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the integer value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static long getLongValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            try {
                return Long.parseLong(parameter.value);
            }
            catch (Throwable e) {
                throw new UserDirectoryParameterException(String.format("Failed to retrieve the long value for the user directory parameter (%s)", parameter.name));
            }
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the long value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static String getStringValue(List<UserDirectoryParameter> parameters, String name) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            return parameter.value;
        }
        throw new UserDirectoryParameterException(String.format("Failed to retrieve the string value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static void setBinaryValue(List<UserDirectoryParameter> parameters, String name, BinaryBuffer value) throws UserDirectoryParameterException {
        UserDirectoryParameter.setBinaryValue(parameters, name, value.getData());
    }

    public static void setBinaryValue(List<UserDirectoryParameter> parameters, String name, byte[] value) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            parameter.setBinaryValue(value);
            return;
        }
        throw new UserDirectoryParameterException(String.format("Failed to set the binary value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static void setDecimalValue(List<UserDirectoryParameter> parameters, String name, BigDecimal value) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            parameter.setDecimalValue(value);
            return;
        }
        throw new UserDirectoryParameterException(String.format("Failed to set the decimal value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static void setDoubleValue(List<UserDirectoryParameter> parameters, String name, double value) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            parameter.setDoubleValue(value);
            return;
        }
        throw new UserDirectoryParameterException(String.format("Failed to set the double value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static void setIntegerValue(List<UserDirectoryParameter> parameters, String name, int value) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            parameter.setIntegerValue(value);
            return;
        }
        throw new UserDirectoryParameterException(String.format("Failed to set the long value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static void setLongValue(List<UserDirectoryParameter> parameters, String name, long value) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            parameter.setLongValue(value);
            return;
        }
        throw new UserDirectoryParameterException(String.format("Failed to set the long value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    public static void setStringValue(List<UserDirectoryParameter> parameters, String name, String value) throws UserDirectoryParameterException {
        for (UserDirectoryParameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase(name)) continue;
            parameter.setStringValue(value);
            return;
        }
        throw new UserDirectoryParameterException(String.format("Failed to set the string value for the user directory parameter (%s): The user directory parameter could not be found", name));
    }

    @JsonIgnore
    public byte[] getBinaryValue() throws UserDirectoryParameterException {
        try {
            return Base64Util.decode((String)this.value);
        }
        catch (Throwable e) {
            throw new UserDirectoryParameterException(String.format("Failed to retrieve the binary value for the user directory parameter (%s)", this.name));
        }
    }

    @JsonIgnore
    public BigDecimal getDecimalValue() throws UserDirectoryParameterException {
        try {
            return new BigDecimal(this.value);
        }
        catch (Throwable e) {
            throw new UserDirectoryParameterException(String.format("Failed to retrieve the decimal value for the user directory parameter (%s)", this.name));
        }
    }

    @JsonIgnore
    public double getDoubleValue() throws UserDirectoryParameterException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (Throwable e) {
            throw new UserDirectoryParameterException(String.format("Failed to retrieve the double value for the user directory parameter (%s)", this.name));
        }
    }

    @JsonIgnore
    public int getIntegerValue() throws UserDirectoryParameterException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (Throwable e) {
            throw new UserDirectoryParameterException(String.format("Failed to retrieve the integer value for the user directory parameter (%s)", this.name));
        }
    }

    @JsonIgnore
    public long getLongValue() throws UserDirectoryParameterException {
        try {
            return Long.parseLong(this.value);
        }
        catch (Throwable e) {
            throw new UserDirectoryParameterException(String.format("Failed to retrieve the long value for the user directory parameter (%s)", this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getStringValue() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public void setBinaryValue(BinaryBuffer value) {
        this.value = Base64Util.encodeBytes((byte[])value.getData());
    }

    @JsonIgnore
    public void setBinaryValue(byte[] value) {
        this.value = Base64Util.encodeBytes((byte[])value);
    }

    @JsonIgnore
    public void setBooleanValue(boolean value) {
        this.value = String.valueOf(value);
    }

    @JsonIgnore
    public void setDecimalValue(BigDecimal value) {
        this.value = String.valueOf(value);
    }

    @JsonIgnore
    public void setDoubleValue(double value) {
        this.value = String.valueOf(value);
    }

    @JsonIgnore
    public void setIntegerValue(int value) {
        this.value = String.valueOf(value);
    }

    @JsonIgnore
    public void setLongValue(long value) {
        this.value = String.valueOf(value);
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setStringValue(String value) {
        this.value = value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

