/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.xml.DtdJarResolver;
import africa.absa.inception.core.xml.XmlParserErrorHandler;
import africa.absa.inception.core.xml.XmlUtil;
import africa.absa.inception.security.InvalidConfigurationException;
import africa.absa.inception.security.Tenant;
import africa.absa.inception.security.UserDirectoryParameter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

@Schema(description="A user directory")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "type", "name", "parameters"})
@Entity
@Table(schema="security", name="user_directories")
public class UserDirectory
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @JsonIgnore
    @Column(name="created", nullable=false, updatable=false)
    private LocalDateTime created;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Id
    @Column(name="id", nullable=false)
    private UUID id;
    @Schema(description="The name of the user directory", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @Schema(description="The parameters for the user directory", required=true)
    @JsonProperty(required=true)
    @Valid
    @Transient
    private List<UserDirectoryParameter> parameters = new ArrayList<UserDirectoryParameter>();
    @JsonIgnore
    @ManyToMany(mappedBy="userDirectories")
    private Set<Tenant> tenants = new HashSet<Tenant>();
    @Schema(description="The code for the user directory type", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="type", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String type;
    @JsonIgnore
    @Column(name="updated", insertable=false)
    private LocalDateTime updated;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserDirectory other = (UserDirectory)object;
        return Objects.equals(this.id, other.id);
    }

    @JsonIgnore
    @Access(value=AccessType.PROPERTY)
    @Column(name="configuration", length=4000, nullable=false)
    public String getConfiguration() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<!DOCTYPE userDirectory SYSTEM \"UserDirectoryConfiguration.dtd\"><userDirectory>");
        for (UserDirectoryParameter parameter : this.parameters) {
            buffer.append("<parameter>");
            buffer.append("<name>").append(parameter.getName()).append("</name>");
            buffer.append("<value>").append(StringUtils.hasText((String)parameter.getValue()) ? parameter.getValue() : "").append("</value>");
            buffer.append("</parameter>");
        }
        buffer.append("</userDirectory>");
        return buffer.toString();
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<UserDirectoryParameter> getParameters() {
        return this.parameters;
    }

    public Set<Tenant> getTenants() {
        return this.tenants;
    }

    public String getType() {
        return this.type;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public void setConfiguration(String configuration) throws InvalidConfigurationException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setValidating(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)new DtdJarResolver("UserDirectoryConfiguration.dtd", "META-INF/UserDirectoryConfiguration.dtd"));
            builder.setErrorHandler((ErrorHandler)new XmlParserErrorHandler());
            InputSource inputSource = new InputSource(new ByteArrayInputStream(configuration.getBytes()));
            Document document = builder.parse(inputSource);
            Element rootElement = document.getDocumentElement();
            this.parameters = new ArrayList<UserDirectoryParameter>();
            NodeList parameterElements = rootElement.getElementsByTagName("parameter");
            for (int i = 0; i < parameterElements.getLength(); ++i) {
                Element parameterElement = (Element)parameterElements.item(i);
                Optional nameOptional = XmlUtil.getChildElementText((Element)parameterElement, (String)"name");
                Optional valueOptional = XmlUtil.getChildElementText((Element)parameterElement, (String)"value");
                if (!nameOptional.isPresent() || !valueOptional.isPresent()) continue;
                this.parameters.add(new UserDirectoryParameter((String)nameOptional.get(), (String)valueOptional.get()));
            }
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException("Failed to parse the XML configuration data for the user directory", e);
        }
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<UserDirectoryParameter> parameters) {
        this.parameters = parameters;
    }

    public void setTenants(Set<Tenant> tenants) {
        this.tenants = tenants;
    }

    public void setType(String type) {
        this.type = type;
    }

    @PrePersist
    protected void onCreate() {
        this.created = LocalDateTime.now();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updated = LocalDateTime.now();
    }
}

