/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.ISecurityService;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserDetails;
import africa.absa.inception.security.UserNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsService
implements org.springframework.security.core.userdetails.UserDetailsService {
    @Autowired
    private ISecurityService securityService;

    public org.springframework.security.core.userdetails.UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            Optional<UUID> userDirectoryIdOptional = this.securityService.getUserDirectoryIdForUser(username);
            if (userDirectoryIdOptional.isEmpty()) {
                throw new UsernameNotFoundException("Failed to retrieve the details for the user (" + username + "): The user is not associated with any of the configured user directories");
            }
            UUID userDirectoryId = userDirectoryIdOptional.get();
            User user = this.securityService.getUser(userDirectoryId, username);
            List<String> functionCodes = this.securityService.getFunctionCodesForUser(userDirectoryId, username);
            List<UUID> tenantIds = this.securityService.getTenantIdsForUserDirectory(userDirectoryId);
            ArrayList<UUID> userDirectoryIdsForTenants = new ArrayList<UUID>();
            for (UUID tenantId : tenantIds) {
                List<UUID> userDirectoryIdsForTenant = this.securityService.getUserDirectoryIdsForTenant(tenantId);
                userDirectoryIdsForTenants.addAll(userDirectoryIdsForTenant);
            }
            List<String> roleCodes = this.securityService.getRoleCodesForUser(userDirectoryId, username);
            return new UserDetails(user, roleCodes, functionCodes, tenantIds, userDirectoryIdsForTenants);
        }
        catch (UserNotFoundException e) {
            throw new UsernameNotFoundException("Failed to retrieve the details for the user (" + username + "): The user could not be found");
        }
        catch (UsernameNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to retrieve the details for the user (" + username + ")", e);
        }
    }
}

