/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.util.Base64Util;
import africa.absa.inception.core.util.BinaryBuffer;
import africa.absa.inception.security.UserAttributeException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A user attribute in the form of a name-value pair")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "value"})
public class UserAttribute
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The name of the user attribute", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String name;
    @Schema(description="The value for the user attribute", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String value;

    public UserAttribute() {
    }

    public UserAttribute(String name, BigDecimal value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public UserAttribute(String name, BinaryBuffer value) {
        this.name = name;
        this.value = Base64Util.encodeBytes((byte[])value.getData());
    }

    public UserAttribute(String name, byte[] value) {
        this.name = name;
        this.value = Base64Util.encodeBytes((byte[])value);
    }

    public UserAttribute(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public UserAttribute(String name, long value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public UserAttribute(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static boolean contains(List<UserAttribute> list, String name) {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getBinaryValue(List<UserAttribute> list, String name) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            try {
                return Base64Util.decode((String)userAttribute.value);
            }
            catch (Throwable e) {
                throw new UserAttributeException(String.format("Failed to retrieve the binary value for the user attribute (%s)", userAttribute.name));
            }
        }
        throw new UserAttributeException(String.format("Failed to retrieve the binary value for the user attribute (%s): The attribute could not be found", name));
    }

    public static BigDecimal getDecimalValue(List<UserAttribute> list, String name) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            try {
                return new BigDecimal(userAttribute.value);
            }
            catch (Throwable e) {
                throw new UserAttributeException(String.format("Failed to retrieve the decimal value for the user attribute (%s)", userAttribute.name));
            }
        }
        throw new UserAttributeException(String.format("Failed to retrieve the decimal value for the user attribute (%s): The attribute could not be found", name));
    }

    public static double getDoubleValue(List<UserAttribute> list, String name) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            try {
                return Double.parseDouble(userAttribute.value);
            }
            catch (Throwable e) {
                throw new UserAttributeException(String.format("Failed to retrieve the double value for the user attribute (%s)", userAttribute.name));
            }
        }
        throw new UserAttributeException(String.format("Failed to retrieve the double value for the user attribute (%s): The attribute could not be found", name));
    }

    public static int getIntegerValue(List<UserAttribute> list, String name) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            try {
                return Integer.parseInt(userAttribute.value);
            }
            catch (Throwable e) {
                throw new UserAttributeException(String.format("Failed to retrieve the integer value for the user attribute (%s)", userAttribute.name));
            }
        }
        throw new UserAttributeException(String.format("Failed to retrieve the integer value for the user attribute (%s): The attribute could not be found", name));
    }

    public static long getLongValue(List<UserAttribute> list, String name) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            try {
                return Long.parseLong(userAttribute.value);
            }
            catch (Throwable e) {
                throw new UserAttributeException(String.format("Failed to retrieve the long value for the user attribute (%s)", userAttribute.name));
            }
        }
        throw new UserAttributeException(String.format("Failed to retrieve the long value for the user attribute (%s): The attribute could not be found", name));
    }

    public static String getStringValue(List<UserAttribute> list, String name) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            return userAttribute.value;
        }
        throw new UserAttributeException(String.format("Failed to retrieve the string value for the user attribute (%s): The attribute could not be found", name));
    }

    public static void setBinaryValue(List<UserAttribute> list, String name, BinaryBuffer value) throws UserAttributeException {
        UserAttribute.setBinaryValue(list, name, value.getData());
    }

    public static void setBinaryValue(List<UserAttribute> list, String name, byte[] value) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            userAttribute.setBinaryValue(value);
            return;
        }
        throw new UserAttributeException(String.format("Failed to set the binary value for the user attribute (%s): The attribute could not be found", name));
    }

    public static void setDecimalValue(List<UserAttribute> list, String name, BigDecimal value) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            userAttribute.setDecimalValue(value);
            return;
        }
        throw new UserAttributeException(String.format("Failed to set the decimal value for the user attribute (%s): The attribute could not be found", name));
    }

    public static void setDoubleValue(List<UserAttribute> list, String name, double value) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            userAttribute.setDoubleValue(value);
            return;
        }
        throw new UserAttributeException(String.format("Failed to set the double value for the user attribute (%s): The attribute could not be found", name));
    }

    public static void setIntegerValue(List<UserAttribute> list, String name, int value) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            userAttribute.setIntegerValue(value);
            return;
        }
        throw new UserAttributeException(String.format("Failed to set the integer value for the user attribute (%s): The attribute could not be found", name));
    }

    public static void setLongValue(List<UserAttribute> list, String name, long value) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            userAttribute.setLongValue(value);
            return;
        }
        throw new UserAttributeException(String.format("Failed to set the long value for the user attribute (%s): The attribute could not be found", name));
    }

    public static void setStringValue(List<UserAttribute> list, String name, String value) throws UserAttributeException {
        for (UserAttribute userAttribute : list) {
            if (!userAttribute.name.equalsIgnoreCase(name)) continue;
            userAttribute.setStringValue(value);
            return;
        }
        throw new UserAttributeException(String.format("Failed to set the string value for the user attribute (%s): The attribute could not be found", name));
    }

    public byte[] getBinaryValue() throws UserAttributeException {
        try {
            return Base64Util.decode((String)this.value);
        }
        catch (Throwable e) {
            throw new UserAttributeException(String.format("Failed to retrieve the binary value for the user attribute (%s)", this.name));
        }
    }

    public BigDecimal getDecimalValue() throws UserAttributeException {
        try {
            return new BigDecimal(this.value);
        }
        catch (Throwable e) {
            throw new UserAttributeException(String.format("Failed to retrieve the decimal value for the user attribute (%s)", this.name));
        }
    }

    public double getDoubleValue() throws UserAttributeException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (Throwable e) {
            throw new UserAttributeException(String.format("Failed to retrieve the double value for the user attribute (%s)", this.name));
        }
    }

    public int getIntegerValue() throws UserAttributeException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (Throwable e) {
            throw new UserAttributeException(String.format("Failed to retrieve the integer value for the user attribute (%s)", this.name));
        }
    }

    public long getLongValue() throws UserAttributeException {
        try {
            return Long.parseLong(this.value);
        }
        catch (Throwable e) {
            throw new UserAttributeException(String.format("Failed to retrieve the long value for the user attribute (%s)", this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setBinaryValue(BinaryBuffer value) {
        this.value = Base64Util.encodeBytes((byte[])value.getData());
    }

    public void setBinaryValue(byte[] value) {
        this.value = Base64Util.encodeBytes((byte[])value);
    }

    public void setDecimalValue(BigDecimal value) {
        this.value = String.valueOf(value);
    }

    public void setDoubleValue(double value) {
        this.value = String.valueOf(value);
    }

    public void setIntegerValue(int value) {
        this.value = String.valueOf(value);
    }

    public void setLongValue(long value) {
        this.value = String.valueOf(value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStringValue(String value) {
        this.value = value;
    }
}

