/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Group;
import africa.absa.inception.security.UserStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Schema(description="A user")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectoryId", "username", "name", "preferredName", "mobileNumber", "phoneNumber", "email", "status", "password", "passwordAttempts", "passwordExpiry"})
@Entity
@Table(schema="security", name="users")
public class User
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @JsonIgnore
    @Column(name="created", nullable=false, updatable=false)
    private LocalDateTime created;
    @Schema(description="The e-mail address for the user")
    @JsonProperty
    @Size(max=100)
    @Pattern(message="invalid e-mail address", regexp="^$|(?:[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-zA-Z0-9-]*[a-zA-Z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])")
    @Column(name="email", length=100)
    private @Size(max=100) @Pattern(message="invalid e-mail address", regexp="^$|(?:[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-zA-Z0-9-]*[a-zA-Z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])") String email;
    @JsonIgnore
    @ManyToMany(mappedBy="users")
    private Set<Group> groups = new HashSet<Group>();
    @JsonIgnore
    @Id
    @Column(name="id", nullable=false)
    private UUID id;
    @Schema(description="The international format mobile number for the user")
    @JsonProperty
    @Size(max=100)
    @Pattern(message="invalid international format mobile number", regexp="^$|(\\+|00)(297|93|244|1264|358|355|376|971|54|374|1684|1268|61|43|994|257|32|229|226|880|359|973|1242|387|590|375|501|1441|591|55|1246|673|975|267|236|1|61|41|56|86|225|237|243|242|682|57|269|238|506|53|5999|61|1345|357|420|49|253|1767|45|1809|1829|1849|213|593|20|291|212|34|372|251|358|679|500|33|298|691|241|44|995|44|233|350|224|590|220|245|240|30|1473|299|502|594|1671|592|852|504|385|509|36|62|44|91|246|353|98|964|354|972|39|1876|44|962|81|76|77|254|996|855|686|1869|82|383|965|856|961|231|218|1758|423|94|266|370|352|371|853|590|212|377|373|261|960|52|692|389|223|356|95|382|976|1670|258|222|1664|596|230|265|60|262|264|687|227|672|234|505|683|31|47|977|674|64|968|92|507|64|51|63|680|675|48|1787|1939|850|351|595|970|689|974|262|40|7|250|966|249|221|65|500|4779|677|232|503|378|252|508|381|211|239|597|421|386|46|268|1721|248|963|1649|235|228|66|992|690|993|670|676|1868|216|90|688|886|255|256|380|598|1|998|3906698|379|1784|58|1284|1340|84|678|681|685|967|27|260|263)(9[976]\\d|8[987530]\\d|6[987]\\d|5[90]\\d|42\\d|3[875]\\d|2[98654321]\\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)\\d{4,20}$")
    @Column(name="mobile_number", length=100)
    private @Size(max=100) @Pattern(message="invalid international format mobile number", regexp="^$|(\\+|00)(297|93|244|1264|358|355|376|971|54|374|1684|1268|61|43|994|257|32|229|226|880|359|973|1242|387|590|375|501|1441|591|55|1246|673|975|267|236|1|61|41|56|86|225|237|243|242|682|57|269|238|506|53|5999|61|1345|357|420|49|253|1767|45|1809|1829|1849|213|593|20|291|212|34|372|251|358|679|500|33|298|691|241|44|995|44|233|350|224|590|220|245|240|30|1473|299|502|594|1671|592|852|504|385|509|36|62|44|91|246|353|98|964|354|972|39|1876|44|962|81|76|77|254|996|855|686|1869|82|383|965|856|961|231|218|1758|423|94|266|370|352|371|853|590|212|377|373|261|960|52|692|389|223|356|95|382|976|1670|258|222|1664|596|230|265|60|262|264|687|227|672|234|505|683|31|47|977|674|64|968|92|507|64|51|63|680|675|48|1787|1939|850|351|595|970|689|974|262|40|7|250|966|249|221|65|500|4779|677|232|503|378|252|508|381|211|239|597|421|386|46|268|1721|248|963|1649|235|228|66|992|690|993|670|676|1868|216|90|688|886|255|256|380|598|1|998|3906698|379|1784|58|1284|1340|84|678|681|685|967|27|260|263)(9[976]\\d|8[987530]\\d|6[987]\\d|5[90]\\d|42\\d|3[875]\\d|2[98654321]\\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)\\d{4,20}$") String mobileNumber;
    @Schema(description="The name of the user", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(max=100) String name;
    @Schema(description="The password or password hash for the user")
    @JsonProperty
    @Size(max=100)
    @Column(name="password", length=100, nullable=false)
    private @Size(max=100) String password;
    @Schema(description="The number of failed authentication attempts as a result of an incorrect password for the user", example="0")
    @JsonProperty
    @Column(name="password_attempts", nullable=false)
    private Integer passwordAttempts;
    @Schema(description="The date and time the password for the user expires")
    @JsonProperty
    @Column(name="password_expiry", nullable=false)
    private LocalDateTime passwordExpiry;
    @Schema(description="The phone number for the user")
    @JsonProperty
    @Size(max=100)
    @Column(name="phone_number", length=100)
    private @Size(max=100) String phoneNumber;
    @Schema(description="The preferred name for the user")
    @JsonProperty
    @Size(max=100)
    @Column(name="preferred_name", length=100)
    private @Size(max=100) String preferredName;
    @Schema(description="The status for the user", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Column(name="status", nullable=false)
    private UserStatus status;
    @JsonIgnore
    @Column(name="updated", insertable=false)
    private LocalDateTime updated;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory the user is associated with", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Column(name="user_directory_id", nullable=false)
    private UUID userDirectoryId;
    @Schema(description="The username for the user", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="username", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String username;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        User other = (User)object;
        return Objects.equals(this.id, other.id);
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getEmail() {
        return this.email;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPasswordAttempts() {
        return this.passwordAttempts;
    }

    public LocalDateTime getPasswordExpiry() {
        return this.passwordExpiry;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }

    public String getUsername() {
        if (this.username != null) {
            this.username = this.username.toLowerCase();
        }
        return this.username;
    }

    public boolean hasPasswordExpired() {
        if (this.passwordExpiry != null) {
            return LocalDateTime.now().isAfter(this.passwordExpiry);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    @JsonIgnore
    public boolean isActive() {
        return this.status == UserStatus.ACTIVE;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.status == UserStatus.EXPIRED;
    }

    @JsonIgnore
    public boolean isLocked() {
        return this.status == UserStatus.LOCKED;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordAttempts(int passwordAttempts) {
        this.passwordAttempts = passwordAttempts;
    }

    public void setPasswordExpiry(LocalDateTime passwordExpiry) {
        this.passwordExpiry = passwordExpiry;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPreferredName(String preferredName) {
        this.preferredName = preferredName;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public void setUserDirectoryId(UUID userDirectoryId) {
        this.userDirectoryId = userDirectoryId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @PrePersist
    protected void onCreate() {
        this.created = LocalDateTime.now();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updated = LocalDateTime.now();
    }
}

