/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;

@Schema(description="A tenant user directory association")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tenantId", "userDirectoryId"})
public class TenantUserDirectory
implements Serializable {
    @Schema(description="The Universally Unique Identifier (UUID) for the tenant", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Id
    @Column(name="tenantId", nullable=false)
    private UUID tenantId;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Id
    @Column(name="userDirectoryId", nullable=false)
    private UUID userDirectoryId;

    public TenantUserDirectory() {
    }

    public TenantUserDirectory(UUID tenantId, UUID userDirectoryId) {
        this.tenantId = tenantId;
        this.userDirectoryId = userDirectoryId;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setUserDirectoryId(UUID userDirectoryId) {
        this.userDirectoryId = userDirectoryId;
    }
}

