/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The tenant status")
public enum TenantStatus {
    INACTIVE("inactive", "Inactive"),
    ACTIVE("active", "Active");

    private final String code;
    private final String description;

    private TenantStatus(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonCreator
    public static TenantStatus fromCode(String code) {
        switch (code) {
            case "inactive": {
                return INACTIVE;
            }
            case "active": {
                return ACTIVE;
            }
        }
        throw new RuntimeException("Failed to determine the tenant status with the invalid code (" + code + ")");
    }

    public static int toNumericCode(TenantStatus tenantStatus) {
        switch (tenantStatus) {
            case ACTIVE: {
                return 1;
            }
            case INACTIVE: {
                return 2;
            }
        }
        throw new RuntimeException("Failed to determine the numeric code for the tenant status (" + tenantStatus.code() + ")");
    }

    public static TenantStatus fromNumericCode(int numericCode) {
        switch (numericCode) {
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return INACTIVE;
            }
        }
        throw new RuntimeException("Failed to determine the tenant status for the numeric code (" + numericCode + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

