/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Tenant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TenantRepository
extends JpaRepository<Tenant, UUID> {
    @Modifying
    @Query(value="insert into security.user_directory_to_tenant_map(tenant_id, user_directory_id) values (:tenantId, :userDirectoryId)", nativeQuery=true)
    public void addUserDirectoryToTenant(@Param(value="tenantId") UUID var1, @Param(value="userDirectoryId") UUID var2);

    public long countByNameContainingIgnoreCase(String var1);

    @Query(value="select count(user_directory_id) from security.user_directory_to_tenant_map where tenant_id = :tenantId and user_directory_id = :userDirectoryId", nativeQuery=true)
    public long countTenantUserDirectory(@Param(value="tenantId") UUID var1, @Param(value="userDirectoryId") UUID var2);

    @Modifying
    @Query(value="delete from Tenant u where u.id = :tenantId")
    public void deleteById(@Param(value="tenantId") UUID var1);

    public boolean existsByNameIgnoreCase(String var1);

    public Page<Tenant> findAllByOrderByNameAsc(Pageable var1);

    public Page<Tenant> findAllByOrderByNameDesc(Pageable var1);

    @Query(value="select o from Tenant o join o.userDirectories as ud where ud.id = :userDirectoryId")
    public List<Tenant> findAllByUserDirectoryId(@Param(value="userDirectoryId") UUID var1);

    public Page<Tenant> findByNameContainingIgnoreCaseOrderByNameAsc(String var1, Pageable var2);

    public Page<Tenant> findByNameContainingIgnoreCaseOrderByNameDesc(String var1, Pageable var2);

    @Query(value="select o.name from Tenant o where o.id = :tenantId")
    public Optional<String> getNameById(@Param(value="tenantId") UUID var1);

    @Query(value="select ud.id from UserDirectory ud join ud.tenants as o where o.id = :tenantId")
    public List<UUID> getUserDirectoryIdsById(@Param(value="tenantId") UUID var1);

    @Modifying
    @Query(value="delete from security.user_directory_to_tenant_map where tenant_id=:tenantId and user_directory_id = :userDirectoryId", nativeQuery=true)
    public int removeUserDirectoryFromTenant(@Param(value="tenantId") UUID var1, @Param(value="userDirectoryId") UUID var2);
}

