/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.TenantStatus;
import africa.absa.inception.security.UserDirectory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A group of users who share common access with specific privileges to a particular subset of the information managed by a multi-tenant application")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "status"})
@Entity
@Table(schema="security", name="tenants")
public class Tenant
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @JsonIgnore
    @Column(name="created", nullable=false, updatable=false)
    private LocalDateTime created;
    @Schema(description="The Universally Unique Identifier (UUID) for the tenant", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Id
    @Column(name="id", nullable=false)
    private UUID id;
    @Schema(description="The name of the tenant", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @Schema(description="The status for the tenant", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Column(name="status", nullable=false)
    private TenantStatus status;
    @JsonIgnore
    @Column(name="updated", insertable=false)
    private LocalDateTime updated;
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(schema="security", name="user_directory_to_tenant_map", joinColumns={@JoinColumn(name="tenant_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="user_directory_id", referencedColumnName="id")})
    private Set<UserDirectory> userDirectories = new HashSet<UserDirectory>();

    public Tenant() {
    }

    public Tenant(String name, TenantStatus status) {
        this.name = name;
        this.status = status;
    }

    public Tenant(UUID id, String name, TenantStatus status) {
        this.id = id;
        this.name = name;
        this.status = status;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tenant other = (Tenant)object;
        return Objects.equals(this.id, other.id);
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TenantStatus getStatus() {
        return this.status;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public Set<UserDirectory> getUserDirectories() {
        return this.userDirectories;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public void linkUserDirectory(UserDirectory userDirectory) {
        this.userDirectories.add(userDirectory);
        userDirectory.getTenants().add(this);
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(TenantStatus status) {
        this.status = status;
    }

    public void setUserDirectories(Set<UserDirectory> userDirectories) {
        this.userDirectories = userDirectories;
    }

    public void unlinkUserDirectory(UserDirectory userDirectory) {
        this.userDirectories.remove(userDirectory);
        userDirectory.getTenants().remove(this);
    }

    @PrePersist
    protected void onCreate() {
        this.created = LocalDateTime.now();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updated = LocalDateTime.now();
    }
}

