/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.AuthenticationFailedException;
import africa.absa.inception.security.AuthenticationToken;
import africa.absa.inception.security.ExpiredPasswordException;
import africa.absa.inception.security.ISecurityService;
import africa.absa.inception.security.UserDetailsService;
import africa.absa.inception.security.UserLockedException;
import africa.absa.inception.security.UserNotFoundException;
import java.util.UUID;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityServiceAuthenticationManager
implements AuthenticationManager {
    private final ISecurityService securityService;
    private final UserDetailsService userDetailsService;

    public SecurityServiceAuthenticationManager(ISecurityService securityService, UserDetailsService userDetailsService) {
        this.securityService = securityService;
        this.userDetailsService = userDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            UUID authenticationUserDirectoryId = this.securityService.authenticate(authentication.getPrincipal().toString(), authentication.getCredentials().toString());
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(authentication.getPrincipal().toString());
            return new AuthenticationToken(userDetails);
        }
        catch (AuthenticationFailedException | UserNotFoundException e) {
            throw new BadCredentialsException("Failed to authenticate the user (" + authentication.getPrincipal() + "): Bad credentials");
        }
        catch (UserLockedException e) {
            throw new LockedException("Failed to authenticate the user (" + authentication.getPrincipal() + "): User locked");
        }
        catch (ExpiredPasswordException e) {
            throw new CredentialsExpiredException("Failed to authenticate the user (" + authentication.getPrincipal() + "): Credentials expired");
        }
        catch (Throwable e) {
            throw new AuthenticationServiceException("Failed to authenticate the user (" + authentication.getPrincipal() + ")", e);
        }
    }
}

