/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.service.ValidationError;
import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.core.util.PasswordUtil;
import africa.absa.inception.core.util.RandomStringGenerator;
import africa.absa.inception.core.util.ResourceUtil;
import africa.absa.inception.mail.IMailService;
import africa.absa.inception.mail.MailTemplate;
import africa.absa.inception.mail.MailTemplateContentType;
import africa.absa.inception.security.AuthenticationFailedException;
import africa.absa.inception.security.DuplicateFunctionException;
import africa.absa.inception.security.DuplicateGroupException;
import africa.absa.inception.security.DuplicateTenantException;
import africa.absa.inception.security.DuplicateUserDirectoryException;
import africa.absa.inception.security.DuplicateUserException;
import africa.absa.inception.security.ExistingGroupMembersException;
import africa.absa.inception.security.ExistingPasswordException;
import africa.absa.inception.security.ExpiredPasswordException;
import africa.absa.inception.security.Function;
import africa.absa.inception.security.FunctionNotFoundException;
import africa.absa.inception.security.FunctionRepository;
import africa.absa.inception.security.Group;
import africa.absa.inception.security.GroupMember;
import africa.absa.inception.security.GroupMemberNotFoundException;
import africa.absa.inception.security.GroupMemberType;
import africa.absa.inception.security.GroupMembers;
import africa.absa.inception.security.GroupNotFoundException;
import africa.absa.inception.security.GroupRepository;
import africa.absa.inception.security.GroupRole;
import africa.absa.inception.security.GroupRoleNotFoundException;
import africa.absa.inception.security.Groups;
import africa.absa.inception.security.ISecurityService;
import africa.absa.inception.security.IUserDirectory;
import africa.absa.inception.security.InternalUserDirectory;
import africa.absa.inception.security.InvalidAttributeException;
import africa.absa.inception.security.InvalidSecurityCodeException;
import africa.absa.inception.security.PasswordChangeReason;
import africa.absa.inception.security.PasswordReset;
import africa.absa.inception.security.PasswordResetRepository;
import africa.absa.inception.security.PasswordResetStatus;
import africa.absa.inception.security.Role;
import africa.absa.inception.security.RoleNotFoundException;
import africa.absa.inception.security.RoleRepository;
import africa.absa.inception.security.Tenant;
import africa.absa.inception.security.TenantNotFoundException;
import africa.absa.inception.security.TenantRepository;
import africa.absa.inception.security.TenantUserDirectoryNotFoundException;
import africa.absa.inception.security.Tenants;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserAttribute;
import africa.absa.inception.security.UserDirectories;
import africa.absa.inception.security.UserDirectory;
import africa.absa.inception.security.UserDirectoryCapabilities;
import africa.absa.inception.security.UserDirectoryNotFoundException;
import africa.absa.inception.security.UserDirectoryRepository;
import africa.absa.inception.security.UserDirectorySummaries;
import africa.absa.inception.security.UserDirectorySummary;
import africa.absa.inception.security.UserDirectorySummaryRepository;
import africa.absa.inception.security.UserDirectoryType;
import africa.absa.inception.security.UserDirectoryTypeNotFoundException;
import africa.absa.inception.security.UserDirectoryTypeRepository;
import africa.absa.inception.security.UserLockedException;
import africa.absa.inception.security.UserNotFoundException;
import africa.absa.inception.security.UserRepository;
import africa.absa.inception.security.UserSortBy;
import africa.absa.inception.security.Users;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SecurityService
implements ISecurityService,
InitializingBean {
    private static final int MAX_FILTERED_ORGANISATIONS = 100;
    private static final int MAX_FILTERED_USER_DIRECTORIES = 100;
    private static final String PASSWORD_RESET_MAIL_TEMPLATE_ID = "Inception.Security.PasswordResetMail";
    private static final Logger logger = LoggerFactory.getLogger(SecurityService.class);
    private final ApplicationContext applicationContext;
    private final FunctionRepository functionRepository;
    private final GroupRepository groupRepository;
    private final IMailService mailService;
    private final PasswordResetRepository passwordResetRepository;
    private final RoleRepository roleRepository;
    private final RandomStringGenerator securityCodeGenerator = new RandomStringGenerator(20, (Random)new SecureRandom(), "1234567890ACEFGHJKLMNPQRUVWXYabcdefhijkprstuvwx");
    private final TenantRepository tenantRepository;
    private final UserDirectoryRepository userDirectoryRepository;
    private final UserDirectorySummaryRepository userDirectorySummaryRepository;
    private final UserDirectoryTypeRepository userDirectoryTypeRepository;
    private final UserRepository userRepository;
    private final Validator validator;
    private Map<UUID, IUserDirectory> userDirectories = new ConcurrentHashMap<UUID, IUserDirectory>();

    public SecurityService(ApplicationContext applicationContext, Validator validator, IMailService mailService, FunctionRepository functionRepository, GroupRepository groupRepository, TenantRepository tenantRepository, PasswordResetRepository passwordResetRepository, RoleRepository roleRepository, UserDirectoryRepository userDirectoryRepository, UserDirectorySummaryRepository userDirectorySummaryRepository, UserDirectoryTypeRepository userDirectoryTypeRepository, UserRepository userRepository) {
        this.applicationContext = applicationContext;
        this.validator = validator;
        this.mailService = mailService;
        this.functionRepository = functionRepository;
        this.groupRepository = groupRepository;
        this.tenantRepository = tenantRepository;
        this.passwordResetRepository = passwordResetRepository;
        this.roleRepository = roleRepository;
        this.userDirectoryRepository = userDirectoryRepository;
        this.userDirectorySummaryRepository = userDirectorySummaryRepository;
        this.userDirectoryTypeRepository = userDirectoryTypeRepository;
        this.userRepository = userRepository;
    }

    @Override
    @Transactional
    public void addMemberToGroup(UUID userDirectoryId, String groupName, GroupMemberType memberType, String memberName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (memberType == null) {
            throw new InvalidArgumentException("memberType");
        }
        if (!StringUtils.hasText((String)memberName)) {
            throw new InvalidArgumentException("memberName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.addMemberToGroup(groupName, memberType, memberName);
    }

    @Override
    @Transactional
    public void addRoleToGroup(UUID userDirectoryId, String groupName, String roleCode) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, RoleNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (!StringUtils.hasText((String)roleCode)) {
            throw new InvalidArgumentException("roleCode");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.addRoleToGroup(groupName, roleCode);
    }

    @Override
    @Transactional
    public void addUserDirectoryToTenant(UUID tenantId, UUID userDirectoryId) throws InvalidArgumentException, TenantNotFoundException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            if (!this.tenantRepository.existsById(tenantId)) {
                throw new TenantNotFoundException(tenantId);
            }
            if (!this.userDirectoryRepository.existsById(userDirectoryId)) {
                throw new UserDirectoryNotFoundException(userDirectoryId);
            }
            if (this.tenantRepository.countTenantUserDirectory(tenantId, userDirectoryId) > 0L) {
                return;
            }
            this.tenantRepository.addUserDirectoryToTenant(tenantId, userDirectoryId);
        }
        catch (TenantNotFoundException | UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to add the user directory (" + userDirectoryId + ") to the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    @Transactional
    public void addUserToGroup(UUID userDirectoryId, String groupName, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.addUserToGroup(groupName, username);
    }

    @Override
    @Transactional
    public void adminChangePassword(UUID userDirectoryId, String username, String newPassword, boolean expirePassword, boolean lockUser, boolean resetPasswordHistory, PasswordChangeReason reason) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        if (!StringUtils.hasText((String)newPassword)) {
            throw new InvalidArgumentException("newPassword");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.adminChangePassword(username, newPassword, expirePassword, lockUser, resetPasswordHistory, reason);
    }

    public void afterPropertiesSet() {
        try {
            if (!this.mailService.mailTemplateExists(PASSWORD_RESET_MAIL_TEMPLATE_ID)) {
                byte[] passwordResetMailTemplate = ResourceUtil.getClasspathResource((String)"africa/absa/inception/security/PasswordReset.ftl");
                MailTemplate mailTemplate = new MailTemplate(PASSWORD_RESET_MAIL_TEMPLATE_ID, "Password Reset", MailTemplateContentType.HTML, passwordResetMailTemplate);
                this.mailService.createMailTemplate(mailTemplate);
            }
            this.reloadUserDirectories();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize the Security Service", e);
        }
    }

    @Override
    @Transactional
    public UUID authenticate(String username, String password) throws InvalidArgumentException, AuthenticationFailedException, UserLockedException, ExpiredPasswordException, UserNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        if (!StringUtils.hasText((String)password)) {
            throw new InvalidArgumentException("password");
        }
        try {
            Optional<UUID> internalUserDirectoryIdOptional = this.getInternalUserDirectoryIdForUser(username);
            if (internalUserDirectoryIdOptional.isPresent()) {
                UUID internalUserDirectoryId = internalUserDirectoryIdOptional.get();
                IUserDirectory internalUserDirectory = this.userDirectories.get(internalUserDirectoryId);
                if (internalUserDirectory == null) {
                    throw new ServiceUnavailableException("The user directory ID (" + internalUserDirectoryId + ") for the internal user (" + username + ") is invalid");
                }
                internalUserDirectory.authenticate(username, password);
                return internalUserDirectoryId;
            }
            for (UUID userDirectoryId : this.userDirectories.keySet()) {
                IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
                if (userDirectory == null || userDirectory instanceof InternalUserDirectory || !userDirectory.isExistingUser(username)) continue;
                userDirectory.authenticate(username, password);
                return userDirectoryId;
            }
            throw new UserNotFoundException(username);
        }
        catch (AuthenticationFailedException | ExpiredPasswordException | UserLockedException | UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to authenticate the user (" + username + ")", e);
        }
    }

    @Override
    @Transactional
    public UUID changePassword(String username, String password, String newPassword) throws InvalidArgumentException, AuthenticationFailedException, UserLockedException, ExistingPasswordException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        if (!StringUtils.hasText((String)password)) {
            throw new InvalidArgumentException("password");
        }
        if (!StringUtils.hasText((String)newPassword)) {
            throw new InvalidArgumentException("newPassword");
        }
        try {
            Optional<UUID> internalUserDirectoryIdOptional = this.getInternalUserDirectoryIdForUser(username);
            if (internalUserDirectoryIdOptional.isPresent()) {
                UUID internalUserDirectoryId = internalUserDirectoryIdOptional.get();
                IUserDirectory internalUserDirectory = this.userDirectories.get(internalUserDirectoryId);
                if (internalUserDirectory == null) {
                    throw new ServiceUnavailableException("The user directory ID (" + internalUserDirectoryId + ") for the internal user (" + username + ") is invalid");
                }
                internalUserDirectory.changePassword(username, password, newPassword);
                return internalUserDirectoryId;
            }
            for (UUID userDirectoryId : this.userDirectories.keySet()) {
                IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
                if (userDirectory == null || userDirectory instanceof InternalUserDirectory || !userDirectory.isExistingUser(username)) continue;
                userDirectory.changePassword(username, password, newPassword);
                return userDirectoryId;
            }
            throw new AuthenticationFailedException("Authentication failed while attempting to change the password for the user (" + username + ")");
        }
        catch (AuthenticationFailedException | ExistingPasswordException | UserLockedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to change the password for the user (" + username + ")", e);
        }
    }

    @Override
    @Transactional
    public void createFunction(Function function) throws InvalidArgumentException, DuplicateFunctionException, ServiceUnavailableException {
        this.validateFunction(function);
        try {
            if (this.functionRepository.existsById(function.getCode())) {
                throw new DuplicateFunctionException(function.getCode());
            }
            this.functionRepository.saveAndFlush(function);
        }
        catch (DuplicateFunctionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the function (" + function.getCode() + ")", e);
        }
    }

    @Override
    @Transactional
    public void createGroup(Group group) throws InvalidArgumentException, UserDirectoryNotFoundException, DuplicateGroupException, ServiceUnavailableException {
        this.validateGroup(group);
        IUserDirectory userDirectory = this.userDirectories.get(group.getUserDirectoryId());
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(group.getUserDirectoryId());
        }
        userDirectory.createGroup(group);
    }

    @Override
    @Transactional
    public Optional<UserDirectory> createTenant(Tenant tenant, boolean createUserDirectory) throws InvalidArgumentException, DuplicateTenantException, ServiceUnavailableException {
        this.validateTenant(tenant);
        UserDirectory userDirectory = null;
        try {
            if (tenant.getId() != null && this.tenantRepository.existsById(tenant.getId())) {
                throw new DuplicateTenantException(tenant.getId());
            }
            if (this.tenantRepository.existsByNameIgnoreCase(tenant.getName())) {
                throw new DuplicateTenantException(tenant.getName());
            }
            if (createUserDirectory) {
                userDirectory = this.newInternalUserDirectoryForTenant(tenant);
                tenant.linkUserDirectory(userDirectory);
            }
            this.tenantRepository.saveAndFlush(tenant);
            try {
                this.reloadUserDirectories();
            }
            catch (Throwable e) {
                logger.error("Failed to reload the user directories", e);
            }
            return Optional.ofNullable(userDirectory);
        }
        catch (DuplicateTenantException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the tenant (" + tenant.getId() + ")", e);
        }
    }

    @Override
    @Transactional
    public void createUser(User user, boolean expiredPassword, boolean userLocked) throws InvalidArgumentException, UserDirectoryNotFoundException, DuplicateUserException, ServiceUnavailableException {
        this.validateUser(user);
        IUserDirectory userDirectory = this.userDirectories.get(user.getUserDirectoryId());
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(user.getUserDirectoryId());
        }
        if (this.getUserDirectoryIdForUser(user.getUsername()).isPresent()) {
            throw new DuplicateUserException(user.getUsername());
        }
        userDirectory.createUser(user, expiredPassword, userLocked);
    }

    @Override
    @Transactional
    public void createUserDirectory(UserDirectory userDirectory) throws InvalidArgumentException, DuplicateUserDirectoryException, ServiceUnavailableException {
        this.validateUserDirectory(userDirectory);
        try {
            if (userDirectory.getId() != null && this.userDirectoryRepository.existsById(userDirectory.getId())) {
                throw new DuplicateUserDirectoryException(userDirectory.getId());
            }
            if (this.userDirectoryRepository.existsByNameIgnoreCase(userDirectory.getName())) {
                throw new DuplicateUserDirectoryException(userDirectory.getName());
            }
            this.userDirectoryRepository.saveAndFlush(userDirectory);
            try {
                this.reloadUserDirectories();
            }
            catch (Throwable e) {
                logger.error("Failed to reload the user directories", e);
            }
        }
        catch (DuplicateUserDirectoryException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the user directory (" + userDirectory.getName() + ")", e);
        }
    }

    @Override
    @Transactional
    public void deleteFunction(String functionCode) throws InvalidArgumentException, FunctionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)functionCode)) {
            throw new InvalidArgumentException("functionCode");
        }
        try {
            if (!this.functionRepository.existsById(functionCode)) {
                throw new FunctionNotFoundException(functionCode);
            }
            this.functionRepository.deleteById(functionCode);
        }
        catch (FunctionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the function (" + functionCode + ")", e);
        }
    }

    @Override
    @Transactional
    public void deleteGroup(UUID userDirectoryId, String groupName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ExistingGroupMembersException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.deleteGroup(groupName);
    }

    @Override
    @Transactional
    public void deleteTenant(UUID tenantId) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        try {
            if (!this.tenantRepository.existsById(tenantId)) {
                throw new TenantNotFoundException(tenantId);
            }
            this.tenantRepository.deleteById(tenantId);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    @Transactional
    public void deleteUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.deleteUser(username);
    }

    @Override
    @Transactional
    public void deleteUserDirectory(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            if (!this.userDirectoryRepository.existsById(userDirectoryId)) {
                throw new UserDirectoryNotFoundException(userDirectoryId);
            }
            this.userDirectoryRepository.deleteById(userDirectoryId);
            try {
                this.reloadUserDirectories();
            }
            catch (Throwable e) {
                logger.error("Failed to reload the user directories", e);
            }
        }
        catch (UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public List<User> findUsers(UUID userDirectoryId, List<UserAttribute> userAttributes) throws InvalidArgumentException, UserDirectoryNotFoundException, InvalidAttributeException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (userAttributes == null) {
            throw new InvalidArgumentException("attributes");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.findUsers(userAttributes);
    }

    @Override
    public Function getFunction(String functionCode) throws InvalidArgumentException, FunctionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)functionCode)) {
            throw new InvalidArgumentException("functionCode");
        }
        try {
            Optional functionOptional = this.functionRepository.findById(functionCode);
            if (functionOptional.isPresent()) {
                return (Function)functionOptional.get();
            }
            throw new FunctionNotFoundException(functionCode);
        }
        catch (FunctionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the function (" + functionCode + ")", e);
        }
    }

    @Override
    public List<String> getFunctionCodesForUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getFunctionCodesForUser(username);
    }

    @Override
    public List<Function> getFunctions() throws ServiceUnavailableException {
        try {
            return this.functionRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the functions", e);
        }
    }

    @Override
    public Group getGroup(UUID userDirectoryId, String groupName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getGroup(groupName);
    }

    @Override
    public List<String> getGroupNames(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getGroupNames();
    }

    @Override
    public List<String> getGroupNamesForUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getGroupNamesForUser(username);
    }

    @Override
    public List<Group> getGroups(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getGroups();
    }

    @Override
    public Groups getGroups(UUID userDirectoryId, String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (pageIndex != null && pageIndex < 0) {
            throw new InvalidArgumentException("pageIndex");
        }
        if (pageSize != null && pageSize <= 0) {
            throw new InvalidArgumentException("pageSize");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getGroups(filter, sortDirection, pageIndex, pageSize);
    }

    @Override
    public List<Group> getGroupsForUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getGroupsForUser(username);
    }

    @Override
    public List<GroupMember> getMembersForGroup(UUID userDirectoryId, String groupName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getMembersForGroup(groupName);
    }

    @Override
    @Transactional
    public GroupMembers getMembersForGroup(UUID userDirectoryId, String groupName, String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (pageIndex != null && pageIndex < 0) {
            throw new InvalidArgumentException("pageIndex");
        }
        if (pageSize != null && pageSize <= 0) {
            throw new InvalidArgumentException("pageSize");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getMembersForGroup(groupName, filter, sortDirection, pageIndex, pageSize);
    }

    @Override
    public List<String> getRoleCodesForGroup(UUID userDirectoryId, String groupName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getRoleCodesForGroup(groupName);
    }

    @Override
    public List<String> getRoleCodesForUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getRoleCodesForUser(username);
    }

    @Override
    public List<Role> getRoles() throws ServiceUnavailableException {
        try {
            return this.roleRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the roles", e);
        }
    }

    @Override
    public List<GroupRole> getRolesForGroup(UUID userDirectoryId, String groupName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getRolesForGroup(groupName);
    }

    @Override
    public Tenant getTenant(UUID tenantId) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        try {
            Optional tenantOptional = this.tenantRepository.findById(tenantId);
            if (tenantOptional.isPresent()) {
                return (Tenant)tenantOptional.get();
            }
            throw new TenantNotFoundException(tenantId);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    public List<UUID> getTenantIdsForUserDirectory(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            if (!this.userDirectoryRepository.existsById(userDirectoryId)) {
                throw new UserDirectoryNotFoundException(userDirectoryId);
            }
            return this.userDirectoryRepository.getTenantIdsById(userDirectoryId);
        }
        catch (UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the IDs for the tenants for the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public String getTenantName(UUID tenantId) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        try {
            Optional<String> nameOptional = this.tenantRepository.getNameById(tenantId);
            if (nameOptional.isPresent()) {
                return nameOptional.get();
            }
            throw new TenantNotFoundException(tenantId);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the name of the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    public List<Tenant> getTenants() throws ServiceUnavailableException {
        try {
            return this.tenantRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the tenants", e);
        }
    }

    @Override
    public Tenants getTenants(String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws InvalidArgumentException, ServiceUnavailableException {
        if (pageIndex != null && pageIndex < 0) {
            throw new InvalidArgumentException("pageIndex");
        }
        if (pageSize != null && pageSize <= 0) {
            throw new InvalidArgumentException("pageSize");
        }
        if (pageIndex == null) {
            pageIndex = 0;
        }
        if (pageSize == null) {
            pageSize = 100;
        }
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, 100));
        try {
            Page<Tenant> tenantPage = StringUtils.hasText((String)filter) ? (sortDirection == SortDirection.ASCENDING ? this.tenantRepository.findByNameContainingIgnoreCaseOrderByNameAsc(filter, (Pageable)pageRequest) : this.tenantRepository.findByNameContainingIgnoreCaseOrderByNameDesc(filter, (Pageable)pageRequest)) : (sortDirection == SortDirection.ASCENDING ? this.tenantRepository.findAllByOrderByNameAsc((Pageable)pageRequest) : this.tenantRepository.findAllByOrderByNameDesc((Pageable)pageRequest));
            return new Tenants(tenantPage.toList(), tenantPage.getTotalElements(), filter, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            Object message = "Failed to retrieve the tenants";
            if (StringUtils.hasText((String)filter)) {
                message = (String)message + String.format(" matching the filter \"%s\"", filter);
            }
            message = (String)message + " for the page " + pageIndex + " using the page size " + pageSize;
            message = (String)message + ": ";
            message = (String)message + e.getMessage();
            throw new ServiceUnavailableException((String)message, e);
        }
    }

    @Override
    public List<Tenant> getTenantsForUserDirectory(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            if (!this.userDirectoryRepository.existsById(userDirectoryId)) {
                throw new UserDirectoryNotFoundException(userDirectoryId);
            }
            return this.tenantRepository.findAllByUserDirectoryId(userDirectoryId);
        }
        catch (UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the tenants associated with the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public User getUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getUser(username);
    }

    @Override
    public List<UserDirectory> getUserDirectories() throws ServiceUnavailableException {
        try {
            return this.userDirectoryRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user directories", e);
        }
    }

    @Override
    public UserDirectories getUserDirectories(String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws InvalidArgumentException, ServiceUnavailableException {
        if (pageIndex != null && pageIndex < 0) {
            throw new InvalidArgumentException("pageIndex");
        }
        if (pageSize != null && pageSize <= 0) {
            throw new InvalidArgumentException("pageSize");
        }
        if (pageIndex == null) {
            pageIndex = 0;
        }
        if (pageSize == null) {
            pageSize = 100;
        }
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, 100));
        try {
            Page<UserDirectory> userDirectoryPage = StringUtils.hasText((String)filter) ? (sortDirection == SortDirection.ASCENDING ? this.userDirectoryRepository.findByNameContainingIgnoreCaseOrderByNameAsc(filter, (Pageable)pageRequest) : this.userDirectoryRepository.findByNameContainingIgnoreCaseOrderByNameDesc(filter, (Pageable)pageRequest)) : (sortDirection == SortDirection.ASCENDING ? this.userDirectoryRepository.findAllByOrderByNameAsc((Pageable)pageRequest) : this.userDirectoryRepository.findAllByOrderByNameDesc((Pageable)pageRequest));
            return new UserDirectories(userDirectoryPage.toList(), userDirectoryPage.getTotalElements(), filter, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the filtered user directories", e);
        }
    }

    @Override
    public List<UserDirectory> getUserDirectoriesForTenant(UUID tenantId) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        try {
            if (!this.tenantRepository.existsById(tenantId)) {
                throw new TenantNotFoundException(tenantId);
            }
            return this.userDirectoryRepository.findAllByTenantId(tenantId);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user directories associated with the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    public UserDirectory getUserDirectory(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            Optional userDirectoryOptional = this.userDirectoryRepository.findById(userDirectoryId);
            if (userDirectoryOptional.isPresent()) {
                return (UserDirectory)userDirectoryOptional.get();
            }
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        catch (UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public UserDirectoryCapabilities getUserDirectoryCapabilities(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getCapabilities();
    }

    @Override
    public Optional<UUID> getUserDirectoryIdForUser(String username) throws InvalidArgumentException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        try {
            Optional<UUID> internalUserDirectoryIdOptional = this.getInternalUserDirectoryIdForUser(username);
            if (internalUserDirectoryIdOptional.isPresent()) {
                return internalUserDirectoryIdOptional;
            }
            for (UUID userDirectoryId : this.userDirectories.keySet()) {
                IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
                if (userDirectory == null || userDirectory instanceof InternalUserDirectory || !userDirectory.isExistingUser(username)) continue;
                return Optional.of(userDirectoryId);
            }
            return Optional.empty();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user directory ID for the user (" + username + ")", e);
        }
    }

    @Override
    public List<UUID> getUserDirectoryIdsForTenant(UUID tenantId) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        try {
            if (!this.tenantRepository.existsById(tenantId)) {
                throw new TenantNotFoundException(tenantId);
            }
            return this.tenantRepository.getUserDirectoryIdsById(tenantId);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the IDs for the user directories associated with the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    public List<UUID> getUserDirectoryIdsForUser(String username) throws InvalidArgumentException, UserNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        try {
            ArrayList<UUID> userDirectoryIdsForUser = new ArrayList<UUID>();
            Optional<UUID> userDirectoryIdOptional = this.getUserDirectoryIdForUser(username);
            if (userDirectoryIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            List<UUID> tenantIds = this.getTenantIdsForUserDirectory(userDirectoryIdOptional.get());
            for (UUID tenantId : tenantIds) {
                List<UUID> userDirectoryIdsForTenant = this.getUserDirectoryIdsForTenant(tenantId);
                userDirectoryIdsForUser.addAll(userDirectoryIdsForTenant);
            }
            return userDirectoryIdsForUser;
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the IDs for the user directories the user (" + username + ") is associated with", e);
        }
    }

    @Override
    public String getUserDirectoryName(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            Optional<String> nameOptional = this.userDirectoryRepository.getNameById(userDirectoryId);
            if (nameOptional.isPresent()) {
                return nameOptional.get();
            }
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        catch (UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the name of the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public UserDirectorySummaries getUserDirectorySummaries(String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws InvalidArgumentException, ServiceUnavailableException {
        if (pageIndex != null && pageIndex < 0) {
            throw new InvalidArgumentException("pageIndex");
        }
        if (pageSize != null && pageSize <= 0) {
            throw new InvalidArgumentException("pageSize");
        }
        if (pageIndex == null) {
            pageIndex = 0;
        }
        if (pageSize == null) {
            pageSize = 100;
        }
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, 100));
        try {
            Page<UserDirectorySummary> userDirectorySummaryPage = StringUtils.hasText((String)filter) ? (sortDirection == SortDirection.ASCENDING ? this.userDirectorySummaryRepository.findByNameContainingIgnoreCaseOrderByNameAsc(filter, (Pageable)pageRequest) : this.userDirectorySummaryRepository.findByNameContainingIgnoreCaseOrderByNameDesc(filter, (Pageable)pageRequest)) : (sortDirection == SortDirection.ASCENDING ? this.userDirectorySummaryRepository.findAllByOrderByNameAsc((Pageable)pageRequest) : this.userDirectorySummaryRepository.findAllByOrderByNameDesc((Pageable)pageRequest));
            return new UserDirectorySummaries(userDirectorySummaryPage.toList(), userDirectorySummaryPage.getTotalElements(), filter, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the filtered summaries for the user directories", e);
        }
    }

    @Override
    public List<UserDirectorySummary> getUserDirectorySummariesForTenant(UUID tenantId) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        try {
            if (!this.tenantRepository.existsById(tenantId)) {
                throw new TenantNotFoundException(tenantId);
            }
            return this.userDirectorySummaryRepository.findAllByTenantId(tenantId);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the summaries for the user directories associated with the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    public UserDirectoryType getUserDirectoryTypeForUserDirectory(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, UserDirectoryTypeNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            Optional<String> typeOptional = this.userDirectoryRepository.getTypeForUserDirectoryById(userDirectoryId);
            if (typeOptional.isEmpty()) {
                throw new UserDirectoryNotFoundException(userDirectoryId);
            }
            Optional userDirectoryTypeOptional = this.userDirectoryTypeRepository.findById(typeOptional.get());
            if (userDirectoryTypeOptional.isPresent()) {
                return (UserDirectoryType)userDirectoryTypeOptional.get();
            }
            throw new UserDirectoryTypeNotFoundException(typeOptional.get());
        }
        catch (UserDirectoryNotFoundException | UserDirectoryTypeNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user directory type for the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public List<UserDirectoryType> getUserDirectoryTypes() throws ServiceUnavailableException {
        try {
            return this.userDirectoryTypeRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user directory types", e);
        }
    }

    @Override
    public String getUserName(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getUserName(username);
    }

    @Override
    public List<User> getUsers(UUID userDirectoryId) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getUsers();
    }

    @Override
    public Users getUsers(UUID userDirectoryId, String filter, UserSortBy sortBy, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (sortBy == null) {
            sortBy = UserSortBy.NAME;
        }
        if (sortDirection == null) {
            sortDirection = SortDirection.ASCENDING;
        }
        if (pageIndex != null && pageIndex < 0) {
            throw new InvalidArgumentException("pageIndex");
        }
        if (pageSize != null && pageSize <= 0) {
            throw new InvalidArgumentException("pageSize");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.getUsers(filter, sortBy, sortDirection, pageIndex, pageSize);
    }

    @Override
    @Transactional
    public void initiatePasswordReset(String username, String resetPasswordUrl, boolean sendEmail) throws InvalidArgumentException, UserNotFoundException, ServiceUnavailableException {
        this.initiatePasswordReset(username, resetPasswordUrl, sendEmail, null);
    }

    @Override
    @Transactional
    public void initiatePasswordReset(String username, String resetPasswordUrl, boolean sendEmail, String securityCode) throws InvalidArgumentException, UserNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        if (!StringUtils.hasText((String)resetPasswordUrl)) {
            throw new InvalidArgumentException("resetPasswordUrl");
        }
        try {
            Optional<UUID> userDirectoryIdOptional = this.getUserDirectoryIdForUser(username);
            if (userDirectoryIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            IUserDirectory userDirectory = this.userDirectories.get(userDirectoryIdOptional.get());
            User user = userDirectory.getUser(username);
            if (StringUtils.hasText((String)user.getEmail())) {
                if (!StringUtils.hasText((String)securityCode)) {
                    securityCode = this.securityCodeGenerator.nextString();
                }
                String securityCodeHash = PasswordUtil.createPasswordHash((String)securityCode);
                PasswordReset passwordReset = new PasswordReset(username, securityCodeHash);
                if (sendEmail) {
                    this.sendPasswordResetEmail(user, resetPasswordUrl, securityCode);
                }
                this.passwordResetRepository.saveAndFlush(passwordReset);
            } else {
                logger.warn("Failed to send the password reset communication to the user (" + username + ") who does not have a valid e-mail address");
            }
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to initiate the password reset process for the user (" + username + ")", e);
        }
    }

    @Override
    public boolean isExistingUser(UUID userDirectoryId, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.isExistingUser(username);
    }

    @Override
    public boolean isUserInGroup(UUID userDirectoryId, String groupName, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        return userDirectory.isUserInGroup(groupName, username);
    }

    @Override
    public void reloadUserDirectories() throws ServiceUnavailableException {
        try {
            ConcurrentHashMap<UUID, IUserDirectory> reloadedUserDirectories = new ConcurrentHashMap<UUID, IUserDirectory>();
            List<UserDirectoryType> userDirectoryTypes = this.getUserDirectoryTypes();
            for (UserDirectory userDirectory : this.getUserDirectories()) {
                UserDirectoryType userDirectoryType = userDirectoryTypes.stream().filter(possibleUserDirectoryType -> possibleUserDirectoryType.getCode().equals(userDirectory.getType())).findFirst().orElse(null);
                if (userDirectoryType == null) {
                    logger.error("Failed to load the user directory (" + userDirectory.getId() + "): The user directory type (" + userDirectory.getType() + ") was not loaded");
                    continue;
                }
                try {
                    Constructor<IUserDirectory> userDirectoryClassConstructor;
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(userDirectoryType.getUserDirectoryClassName());
                    if (!IUserDirectory.class.isAssignableFrom(clazz)) {
                        throw new ServiceUnavailableException("The user directory class (" + userDirectoryType.getUserDirectoryClassName() + ") does not implement the IUserDirectory interface");
                    }
                    Class<IUserDirectory> userDirectoryClass = clazz.asSubclass(IUserDirectory.class);
                    try {
                        userDirectoryClassConstructor = userDirectoryClass.getConstructor(UUID.class, List.class, GroupRepository.class, UserRepository.class, RoleRepository.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ServiceUnavailableException("The user directory class (" + userDirectoryType.getUserDirectoryClassName() + ") does not provide a valid constructor (long, Map<String,String>)");
                    }
                    IUserDirectory userDirectoryInstance = userDirectoryClassConstructor.newInstance(userDirectory.getId(), userDirectory.getParameters(), this.groupRepository, this.userRepository, this.roleRepository);
                    this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)userDirectoryInstance);
                    reloadedUserDirectories.put(userDirectory.getId(), userDirectoryInstance);
                }
                catch (Throwable e) {
                    throw new ServiceUnavailableException("Failed to initialize the user directory (" + userDirectory.getId() + ")(" + userDirectory.getName() + ")", e);
                }
            }
            this.userDirectories = reloadedUserDirectories;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to reload the user directories", e);
        }
    }

    @Override
    @Transactional
    public void removeMemberFromGroup(UUID userDirectoryId, String groupName, GroupMemberType memberType, String memberName) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, GroupMemberNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (memberType == null) {
            throw new InvalidArgumentException("memberType");
        }
        if (!StringUtils.hasText((String)memberName)) {
            throw new InvalidArgumentException("memberName");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.removeMemberFromGroup(groupName, memberType, memberName);
    }

    @Override
    @Transactional
    public void removeRoleFromGroup(UUID userDirectoryId, String groupName, String roleCode) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, GroupRoleNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (!StringUtils.hasText((String)roleCode)) {
            throw new InvalidArgumentException("roleCode");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.removeRoleFromGroup(groupName, roleCode);
    }

    @Override
    @Transactional
    public void removeUserDirectoryFromTenant(UUID tenantId, UUID userDirectoryId) throws InvalidArgumentException, TenantNotFoundException, TenantUserDirectoryNotFoundException, ServiceUnavailableException {
        if (tenantId == null) {
            throw new InvalidArgumentException("tenantId");
        }
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        try {
            if (!this.tenantRepository.existsById(tenantId)) {
                throw new TenantNotFoundException(tenantId);
            }
            if (this.tenantRepository.countTenantUserDirectory(tenantId, userDirectoryId) == 0L) {
                throw new TenantUserDirectoryNotFoundException(tenantId, userDirectoryId);
            }
            this.tenantRepository.removeUserDirectoryFromTenant(tenantId, userDirectoryId);
        }
        catch (TenantNotFoundException | TenantUserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to add the user directory (" + userDirectoryId + ") to the tenant (" + tenantId + ")", e);
        }
    }

    @Override
    @Transactional
    public void removeUserFromGroup(UUID userDirectoryId, String groupName, String username) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (userDirectoryId == null) {
            throw new InvalidArgumentException("userDirectoryId");
        }
        if (!StringUtils.hasText((String)groupName)) {
            throw new InvalidArgumentException("groupName");
        }
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        IUserDirectory userDirectory = this.userDirectories.get(userDirectoryId);
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(userDirectoryId);
        }
        userDirectory.removeUserFromGroup(groupName, username);
    }

    @Override
    @Transactional
    public void resetPassword(String username, String newPassword, String securityCode) throws InvalidArgumentException, InvalidSecurityCodeException, UserLockedException, ExistingPasswordException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)username)) {
            throw new InvalidArgumentException("username");
        }
        if (!StringUtils.hasText((String)newPassword)) {
            throw new InvalidArgumentException("newPassword");
        }
        if (!StringUtils.hasText((String)securityCode)) {
            throw new InvalidArgumentException("securityCode");
        }
        try {
            Optional<UUID> userDirectoryIdOptional = this.getUserDirectoryIdForUser(username);
            if (userDirectoryIdOptional.isEmpty()) {
                throw new InvalidSecurityCodeException(username);
            }
            List<PasswordReset> passwordResets = this.passwordResetRepository.findAllByUsernameAndStatus(username, PasswordResetStatus.REQUESTED);
            String securityCodeHash = PasswordUtil.createPasswordHash((String)securityCode);
            for (PasswordReset passwordReset : passwordResets) {
                if (!passwordReset.getSecurityCodeHash().equals(securityCodeHash)) continue;
                IUserDirectory userDirectory = this.userDirectories.get(userDirectoryIdOptional.get());
                userDirectory.resetPassword(username, newPassword);
                return;
            }
            throw new InvalidSecurityCodeException(username);
        }
        catch (ExistingPasswordException | InvalidSecurityCodeException | UserLockedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to reset the password for the user (" + username + ")", e);
        }
    }

    @Override
    @Transactional
    public void updateFunction(Function function) throws InvalidArgumentException, FunctionNotFoundException, ServiceUnavailableException {
        this.validateFunction(function);
        try {
            if (!this.functionRepository.existsById(function.getCode())) {
                throw new FunctionNotFoundException(function.getCode());
            }
            this.functionRepository.saveAndFlush(function);
        }
        catch (FunctionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the function (" + function.getCode() + ")", e);
        }
    }

    @Override
    @Transactional
    public void updateGroup(Group group) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        this.validateGroup(group);
        IUserDirectory userDirectory = this.userDirectories.get(group.getUserDirectoryId());
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(group.getUserDirectoryId());
        }
        userDirectory.updateGroup(group);
    }

    @Override
    @Transactional
    public void updateTenant(Tenant tenant) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException {
        this.validateTenant(tenant);
        try {
            Optional tenantOptional = this.tenantRepository.findById(tenant.getId());
            if (!tenantOptional.isPresent()) {
                throw new TenantNotFoundException(tenant.getId());
            }
            Tenant existingTenant = (Tenant)tenantOptional.get();
            existingTenant.setName(tenant.getName());
            existingTenant.setStatus(tenant.getStatus());
            this.tenantRepository.saveAndFlush(existingTenant);
        }
        catch (TenantNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the tenant (" + tenant.getId() + ")", e);
        }
    }

    @Override
    @Transactional
    public void updateUser(User user, boolean expirePassword, boolean lockUser) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException {
        this.validateUser(user);
        IUserDirectory userDirectory = this.userDirectories.get(user.getUserDirectoryId());
        if (userDirectory == null) {
            throw new UserDirectoryNotFoundException(user.getUserDirectoryId());
        }
        userDirectory.updateUser(user, expirePassword, lockUser);
    }

    @Override
    @Transactional
    public void updateUserDirectory(UserDirectory userDirectory) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException {
        this.validateUserDirectory(userDirectory);
        try {
            if (!this.userDirectoryRepository.existsById(userDirectory.getId())) {
                throw new UserDirectoryNotFoundException(userDirectory.getId());
            }
            this.userDirectoryRepository.saveAndFlush(userDirectory);
            this.reloadUserDirectories();
        }
        catch (UserDirectoryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the user directory (" + userDirectory.getName() + ")", e);
        }
    }

    private Optional<UUID> getInternalUserDirectoryIdForUser(String username) throws ServiceUnavailableException {
        try {
            return this.userRepository.getUserDirectoryIdByUsernameIgnoreCase(username);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the ID for the internal user directory for the internal user (" + username + ")", e);
        }
    }

    private boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).length() == 0;
        }
        return false;
    }

    private UserDirectory newInternalUserDirectoryForTenant(Tenant tenant) throws ServiceUnavailableException {
        UserDirectory userDirectory = new UserDirectory();
        if (tenant.getId() != null) {
            userDirectory.setId(tenant.getId());
        }
        userDirectory.setType("InternalUserDirectory");
        userDirectory.setName(tenant.getName() + " Internal User Directory");
        String buffer = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE userDirectory SYSTEM \"UserDirectoryConfiguration.dtd\"><userDirectory><parameter><name>MaxPasswordAttempts</name><value>5</value></parameter><parameter><name>PasswordExpiryMonths</name><value>12</value></parameter><parameter><name>PasswordHistoryMonths</name><value>24</value></parameter><parameter><name>MaxFilteredUsers</name><value>100</value></parameter></userDirectory>";
        try {
            userDirectory.setConfiguration(buffer);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to set the configuration for the user directory", e);
        }
        return userDirectory;
    }

    private void sendPasswordResetEmail(User user, String resetPasswordUrl, String securityCode) throws ServiceUnavailableException {
        try {
            if (StringUtils.hasText((String)user.getEmail())) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("preferredName", user.getPreferredName().toUpperCase());
                parameters.put("securityCode", securityCode);
                parameters.put("resetPasswordUrl", resetPasswordUrl + "?username=" + URLEncoder.encode(user.getUsername(), StandardCharsets.UTF_8) + "&securityCode=" + URLEncoder.encode(securityCode, StandardCharsets.UTF_8));
                this.mailService.sendMail(Collections.singletonList(user.getEmail()), "Password Reset", "no-reply@inception.digital", "Inception", PASSWORD_RESET_MAIL_TEMPLATE_ID, parameters);
            }
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to send the password reset e-mail", e);
        }
    }

    private void validateFunction(Function function) throws InvalidArgumentException {
        if (function == null) {
            throw new InvalidArgumentException("function");
        }
        Set constraintViolations = this.validator.validate((Object)function, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("function", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }

    private void validateGroup(Group group) throws InvalidArgumentException {
        if (group == null) {
            throw new InvalidArgumentException("group");
        }
        Set constraintViolations = this.validator.validate((Object)group, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("group", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }

    private void validateTenant(Tenant tenant) throws InvalidArgumentException {
        if (tenant == null) {
            throw new InvalidArgumentException("tenant");
        }
        Set constraintViolations = this.validator.validate((Object)tenant, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("tenant", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }

    private void validateUser(User user) throws InvalidArgumentException {
        if (user == null) {
            throw new InvalidArgumentException("user");
        }
        Set constraintViolations = this.validator.validate((Object)user, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("user", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }

    private void validateUserDirectory(UserDirectory userDirectory) throws InvalidArgumentException {
        if (userDirectory == null) {
            throw new InvalidArgumentException("userDirectory");
        }
        Set constraintViolations = this.validator.validate((Object)userDirectory, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("userDirectory", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }
}

