/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Function;
import africa.absa.inception.security.Group;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A representation of a particular job function that is used to assign the permissions needed to perform particular system functions to a user")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"code", "name", "description"})
@Entity
@Table(schema="security", name="roles")
public class Role
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The code for the role", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Id
    @Column(name="code", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String code;
    @Schema(description="The description for the role")
    @JsonProperty
    @Size(max=100)
    @Column(name="description", length=100)
    private @Size(max=100) String description;
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(schema="security", name="function_to_role_map", joinColumns={@JoinColumn(name="role_code", referencedColumnName="code")}, inverseJoinColumns={@JoinColumn(name="function_code", referencedColumnName="code")})
    private Set<Function> functions = new HashSet<Function>();
    @JsonIgnore
    @ManyToMany(mappedBy="roles")
    private Set<Group> groups = new HashSet<Group>();
    @Schema(description="The name of the role", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;

    public void addFunction(Function function) {
        this.functions.removeIf(existingFunction -> Objects.equals(existingFunction.getCode(), function.getCode()));
        this.functions.add(function);
        function.getRoles().add(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Role other = (Role)object;
        return Objects.equals(this.code, other.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Function> getFunctions() {
        return this.functions;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.code == null ? 0 : this.code.hashCode();
    }

    public void removeFunction(Function function) {
        this.functions.remove(function);
        function.getRoles().remove(this);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFunctions(Set<Function> functions) {
        this.functions = functions;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void setName(String name) {
        this.name = name;
    }
}

