/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The password reset status")
public enum PasswordResetStatus {
    REQUESTED("requested", "Requested"),
    COMPLETED("completed", "Completed"),
    EXPIRED("expired", "Expired");

    private final String code;
    private final String description;

    private PasswordResetStatus(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonCreator
    public static PasswordResetStatus fromCode(String code) {
        switch (code) {
            case "requested": {
                return REQUESTED;
            }
            case "completed": {
                return COMPLETED;
            }
            case "expired": {
                return EXPIRED;
            }
        }
        throw new RuntimeException("Failed to determine the password reset status with the invalid code (" + code + ")");
    }

    public static int toNumericCode(PasswordResetStatus passwordResetStatus) {
        switch (passwordResetStatus) {
            case REQUESTED: {
                return 1;
            }
            case COMPLETED: {
                return 2;
            }
            case EXPIRED: {
                return 3;
            }
        }
        throw new RuntimeException("Failed to determine the numeric code for the password reset status (" + passwordResetStatus.code() + ")");
    }

    public static PasswordResetStatus fromNumericCode(int numericCode) {
        switch (numericCode) {
            case 1: {
                return REQUESTED;
            }
            case 2: {
                return COMPLETED;
            }
            case 3: {
                return EXPIRED;
            }
        }
        throw new RuntimeException("Failed to determine the password reset status for the numeric code (" + numericCode + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

