/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.PasswordResetId;
import africa.absa.inception.security.PasswordResetStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A password reset")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"username", "requested", "completed", "expired", "status", "securityCodeHash"})
@Entity
@Table(schema="security", name="password_resets")
@IdClass(value=PasswordResetId.class)
public class PasswordReset
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The date and time the password reset was completed")
    @JsonProperty
    @Column(name="completed")
    private LocalDateTime completed;
    @Schema(description="The date and time the password reset expired")
    @JsonProperty
    @Column(name="expired")
    private LocalDateTime expired;
    @Schema(description="The date and time the password reset was requested")
    @JsonProperty
    @Id
    @Column(name="requested", nullable=false)
    private LocalDateTime requested;
    @Schema(description="The security code hash", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="security_code_hash", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String securityCodeHash;
    @Schema(description="The status of the password reset", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Column(name="status", nullable=false)
    private PasswordResetStatus status;
    @Schema(description="The username for the user associated with the password reset", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Id
    @Column(name="username", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String username;

    public PasswordReset() {
    }

    public PasswordReset(String username, String securityCodeHash) {
        this.username = username;
        this.securityCodeHash = securityCodeHash;
        this.requested = LocalDateTime.now();
        this.status = PasswordResetStatus.REQUESTED;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PasswordReset other = (PasswordReset)object;
        return Objects.equals(this.username, other.username) && Objects.equals(this.requested, other.requested);
    }

    public LocalDateTime getCompleted() {
        return this.completed;
    }

    public LocalDateTime getExpired() {
        return this.expired;
    }

    public LocalDateTime getRequested() {
        return this.requested;
    }

    public String getSecurityCodeHash() {
        return this.securityCodeHash;
    }

    public PasswordResetStatus getStatus() {
        return this.status;
    }

    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return (this.username == null ? 0 : this.username.hashCode()) + (this.requested == null ? 0 : this.requested.hashCode());
    }

    public void setCompleted(LocalDateTime completed) {
        this.completed = completed;
    }

    public void setExpired(LocalDateTime expired) {
        this.expired = expired;
    }

    public void setRequested(LocalDateTime requested) {
        this.requested = requested;
    }

    public void setSecurityCodeHash(String securityCodeHash) {
        this.securityCodeHash = securityCodeHash;
    }

    public void setStatus(PasswordResetStatus status) {
        this.status = status;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

