/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The password change reason")
public enum PasswordChangeReason {
    USER("user", "User"),
    ADMINISTRATIVE("administrative", "Administrative"),
    RESET("reset", "Reset");

    private final String code;
    private final String description;

    private PasswordChangeReason(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonCreator
    public static PasswordChangeReason fromCode(String code) {
        switch (code) {
            case "user": {
                return USER;
            }
            case "administrative": {
                return ADMINISTRATIVE;
            }
            case "reset": {
                return RESET;
            }
        }
        throw new RuntimeException("Failed to determine the password change reason with the invalid code (" + code + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

