/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.PasswordChangeReason;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A password change")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"expirePassword", "lockUser", "newPassword", "password", "reason", "resetPasswordHistory", "securityCode"})
public class PasswordChange
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="Expire the user's password when performing an administrative password change")
    @JsonProperty
    private Boolean expirePassword;
    @Schema(description="Lock the user when performing an administrative password change")
    @JsonProperty
    private Boolean lockUser;
    @Schema(description="The new password", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String newPassword;
    @Schema(description="The password for the user that is used to authorise the operation when performing a user password change")
    @JsonProperty
    @Size(min=1, max=100)
    private @Size(min=1, max=100) String password;
    @Schema(description="The reason for changing the password", required=true)
    @JsonProperty(required=true)
    @NotNull
    private PasswordChangeReason reason;
    @Schema(description="Reset the user's password history when performing an administrative password change")
    @JsonProperty
    private Boolean resetPasswordHistory;
    @Schema(description="The security code when performing a forgotten password change.")
    @JsonProperty
    private String securityCode;

    public PasswordChange() {
    }

    public PasswordChange(String newPassword, String password) {
        this.newPassword = newPassword;
        this.password = password;
        this.reason = PasswordChangeReason.USER;
    }

    public PasswordChange(String newPassword, Boolean expirePassword, Boolean lockUser, Boolean resetPasswordHistory) {
        this.newPassword = newPassword;
        this.expirePassword = expirePassword;
        this.lockUser = lockUser;
        this.resetPasswordHistory = resetPasswordHistory;
        this.reason = PasswordChangeReason.ADMINISTRATIVE;
    }

    public Boolean getExpirePassword() {
        return this.expirePassword;
    }

    public Boolean getLockUser() {
        return this.lockUser;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public PasswordChangeReason getReason() {
        return this.reason;
    }

    public Boolean getResetPasswordHistory() {
        return this.resetPasswordHistory;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setExpirePassword(Boolean expirePassword) {
        this.expirePassword = expirePassword;
    }

    public void setLockUser(Boolean lockUser) {
        this.lockUser = lockUser;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReason(PasswordChangeReason reason) {
        this.reason = reason;
    }

    public void setResetPasswordHistory(Boolean resetPasswordHistory) {
        this.resetPasswordHistory = resetPasswordHistory;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }
}

