/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.core.util.JNDIUtil;
import africa.absa.inception.security.AuthenticationFailedException;
import africa.absa.inception.security.DuplicateGroupException;
import africa.absa.inception.security.DuplicateUserException;
import africa.absa.inception.security.ExistingGroupMembersException;
import africa.absa.inception.security.ExistingPasswordException;
import africa.absa.inception.security.ExpiredPasswordException;
import africa.absa.inception.security.Group;
import africa.absa.inception.security.GroupMember;
import africa.absa.inception.security.GroupMemberNotFoundException;
import africa.absa.inception.security.GroupMemberType;
import africa.absa.inception.security.GroupMembers;
import africa.absa.inception.security.GroupNotFoundException;
import africa.absa.inception.security.GroupRepository;
import africa.absa.inception.security.GroupRole;
import africa.absa.inception.security.GroupRoleNotFoundException;
import africa.absa.inception.security.Groups;
import africa.absa.inception.security.InvalidAttributeException;
import africa.absa.inception.security.PasswordChangeReason;
import africa.absa.inception.security.RoleNotFoundException;
import africa.absa.inception.security.RoleRepository;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserAttribute;
import africa.absa.inception.security.UserDirectoryBase;
import africa.absa.inception.security.UserDirectoryCapabilities;
import africa.absa.inception.security.UserDirectoryParameter;
import africa.absa.inception.security.UserLockedException;
import africa.absa.inception.security.UserNotFoundException;
import africa.absa.inception.security.UserRepository;
import africa.absa.inception.security.UserSortBy;
import africa.absa.inception.security.UserStatus;
import africa.absa.inception.security.Users;
import com.github.f4b6a3.uuid.UuidCreator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

public class LDAPUserDirectory
extends UserDirectoryBase {
    private static final int DEFAULT_MAX_FILTERED_GROUPS = 100;
    private static final int DEFAULT_MAX_FILTERED_GROUP_MEMBERS = 100;
    private static final int DEFAULT_MAX_FILTERED_USERS = 100;
    private static final String[] EMPTY_ATTRIBUTE_LIST = new String[0];
    private static final Logger logger = LoggerFactory.getLogger(LDAPUserDirectory.class);
    private final LdapName baseDN;
    private final String bindDN;
    private final String bindPassword;
    private final UserDirectoryCapabilities capabilities;
    private final LdapName groupBaseDN;
    private final String groupMemberAttribute;
    private final String[] groupMemberAttributeArray;
    private final String groupNameAttribute;
    private final String groupObjectClass;
    private final String host;
    private final int maxFilteredGroupMembers;
    private final int maxFilteredGroups;
    private final int maxFilteredUsers;
    private final int port;
    private final boolean useSSL;
    private final LdapName userBaseDN;
    private final String userEmailAttribute;
    private final String userMobileNumberAttribute;
    private final String userNameAttribute;
    private final String userObjectClass;
    private final String userPhoneNumberAttribute;
    private final String userPreferredNameAttribute;
    private final String userUsernameAttribute;
    @Autowired
    @Qualifier(value="applicationDataSource")
    private DataSource dataSource;
    private String groupDescriptionAttribute;

    public LDAPUserDirectory(UUID userDirectoryId, List<UserDirectoryParameter> parameters, GroupRepository groupRepository, UserRepository userRepository, RoleRepository roleRepository) throws ServiceUnavailableException {
        super(userDirectoryId, parameters, groupRepository, userRepository, roleRepository);
        try {
            if (!UserDirectoryParameter.contains(parameters, "Host")) {
                throw new ServiceUnavailableException("No Host parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.host = UserDirectoryParameter.getStringValue(parameters, "Host");
            if (!UserDirectoryParameter.contains(parameters, "Port")) {
                throw new ServiceUnavailableException("No Port parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.port = UserDirectoryParameter.getIntegerValue(parameters, "Port");
            boolean bl = this.useSSL = UserDirectoryParameter.contains(parameters, "UseSSL") && Boolean.parseBoolean(UserDirectoryParameter.getStringValue(parameters, "UseSSL"));
            if (!UserDirectoryParameter.contains(parameters, "BindDN")) {
                throw new ServiceUnavailableException("No BindDN parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.bindDN = UserDirectoryParameter.getStringValue(parameters, "BindDN");
            if (!UserDirectoryParameter.contains(parameters, "BindPassword")) {
                throw new ServiceUnavailableException("No BindPassword parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.bindPassword = UserDirectoryParameter.getStringValue(parameters, "BindPassword");
            if (!UserDirectoryParameter.contains(parameters, "BaseDN")) {
                throw new ServiceUnavailableException("No BindDN parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.baseDN = new LdapName(UserDirectoryParameter.getStringValue(parameters, "BaseDN"));
            if (!UserDirectoryParameter.contains(parameters, "UserBaseDN")) {
                throw new ServiceUnavailableException("No UserBaseDN parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userBaseDN = new LdapName(UserDirectoryParameter.getStringValue(parameters, "UserBaseDN"));
            if (!UserDirectoryParameter.contains(parameters, "GroupBaseDN")) {
                throw new ServiceUnavailableException("No GroupBaseDN parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.groupBaseDN = new LdapName(UserDirectoryParameter.getStringValue(parameters, "GroupBaseDN"));
            if (!UserDirectoryParameter.contains(parameters, "UserObjectClass")) {
                throw new ServiceUnavailableException("No UserObjectClass parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userObjectClass = UserDirectoryParameter.getStringValue(parameters, "UserObjectClass");
            if (!UserDirectoryParameter.contains(parameters, "UserUsernameAttribute")) {
                throw new ServiceUnavailableException("No UserUsernameAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userUsernameAttribute = UserDirectoryParameter.getStringValue(parameters, "UserUsernameAttribute");
            if (!UserDirectoryParameter.contains(parameters, "UserNameAttribute")) {
                throw new ServiceUnavailableException("No UserNameAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userNameAttribute = UserDirectoryParameter.getStringValue(parameters, "UserNameAttribute");
            if (!UserDirectoryParameter.contains(parameters, "UserPreferredNameAttribute")) {
                throw new ServiceUnavailableException("No UserPreferredNameAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userPreferredNameAttribute = UserDirectoryParameter.getStringValue(parameters, "UserPreferredNameAttribute");
            if (!UserDirectoryParameter.contains(parameters, "UserPhoneNumberAttribute")) {
                throw new ServiceUnavailableException("No UserPhoneNumberAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userPhoneNumberAttribute = UserDirectoryParameter.getStringValue(parameters, "UserPhoneNumberAttribute");
            if (!UserDirectoryParameter.contains(parameters, "UserMobileNumberAttribute")) {
                throw new ServiceUnavailableException("No UserMobileNumberAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userMobileNumberAttribute = UserDirectoryParameter.getStringValue(parameters, "UserMobileNumberAttribute");
            if (!UserDirectoryParameter.contains(parameters, "UserEmailAttribute")) {
                throw new ServiceUnavailableException("No UserEmailAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.userEmailAttribute = UserDirectoryParameter.getStringValue(parameters, "UserEmailAttribute");
            if (!UserDirectoryParameter.contains(parameters, "GroupObjectClass")) {
                throw new ServiceUnavailableException("No GroupObjectClass parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.groupObjectClass = UserDirectoryParameter.getStringValue(parameters, "GroupObjectClass");
            if (!UserDirectoryParameter.contains(parameters, "GroupNameAttribute")) {
                throw new ServiceUnavailableException("No GroupNameAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.groupNameAttribute = UserDirectoryParameter.getStringValue(parameters, "GroupNameAttribute");
            if (!UserDirectoryParameter.contains(parameters, "GroupMemberAttribute")) {
                throw new ServiceUnavailableException("No GroupMemberAttribute parameter found for the user directory (" + userDirectoryId + ")");
            }
            this.groupMemberAttribute = UserDirectoryParameter.getStringValue(parameters, "GroupMemberAttribute");
            this.groupMemberAttributeArray = new String[]{this.groupMemberAttribute};
            if (UserDirectoryParameter.contains(parameters, "GroupDescriptionAttribute")) {
                this.groupDescriptionAttribute = UserDirectoryParameter.getStringValue(parameters, "GroupDescriptionAttribute");
            }
            this.maxFilteredUsers = UserDirectoryParameter.contains(parameters, "MaxFilteredUsers") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxFilteredUsers") : 100;
            this.maxFilteredGroups = UserDirectoryParameter.contains(parameters, "MaxFilteredGroups") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxFilteredGroups") : 100;
            this.maxFilteredGroupMembers = UserDirectoryParameter.contains(parameters, "MaxFilteredGroupMembers") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxFilteredGroupMembers") : 100;
            boolean supportsAdminChangePassword = true;
            if (UserDirectoryParameter.contains(parameters, "SupportsAdminChangePassword")) {
                supportsAdminChangePassword = UserDirectoryParameter.getBooleanValue(parameters, "SupportsAdminChangePassword");
            }
            boolean supportsChangePassword = true;
            if (UserDirectoryParameter.contains(parameters, "SupportsChangePassword")) {
                supportsChangePassword = UserDirectoryParameter.getBooleanValue(parameters, "SupportsChangePassword");
            }
            boolean supportsGroupAdministration = true;
            if (UserDirectoryParameter.contains(parameters, "SupportsGroupAdministration")) {
                supportsGroupAdministration = UserDirectoryParameter.getBooleanValue(parameters, "SupportsGroupAdministration");
            }
            boolean supportsGroupMemberAdministration = true;
            if (UserDirectoryParameter.contains(parameters, "SupportsGroupMemberAdministration")) {
                supportsGroupMemberAdministration = UserDirectoryParameter.getBooleanValue(parameters, "SupportsGroupMemberAdministration");
            }
            boolean supportsUserAdministration = true;
            if (UserDirectoryParameter.contains(parameters, "SupportsUserAdministration")) {
                supportsUserAdministration = UserDirectoryParameter.getBooleanValue(parameters, "SupportsUserAdministration");
            }
            this.capabilities = new UserDirectoryCapabilities(supportsAdminChangePassword, supportsChangePassword, supportsGroupAdministration, supportsGroupMemberAdministration, false, false, supportsUserAdministration, false);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to initialize the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public void addMemberToGroup(String groupName, GroupMemberType memberType, String memberName) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsGroupMemberAdministration()) {
            throw new ServiceUnavailableException("The group member administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        if (memberType != GroupMemberType.USER) {
            throw new ServiceUnavailableException("Unsupported group member type (" + memberType.description() + ")");
        }
        if (this.isUserInGroup(groupName, memberName)) {
            return;
        }
        this.addUserToGroup(groupName, memberName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addRoleToGroup(String groupName, String roleCode) throws GroupNotFoundException, RoleNotFoundException, ServiceUnavailableException {
        UUID groupId;
        DirContext dirContext;
        block10: {
            dirContext = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, groupName);
            if (groupDN == null) {
                throw new GroupNotFoundException(groupName);
            }
            if (!this.getRoleRepository().existsById(roleCode)) {
                throw new RoleNotFoundException(roleCode);
            }
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isPresent()) {
                groupId = groupIdOptional.get();
            } else {
                groupId = UuidCreator.getShortPrefixComb();
                Group group = this.getGroup(groupName);
                group.setId(groupId);
                this.getGroupRepository().saveAndFlush(group);
            }
            if (this.getGroupRepository().countGroupRole(groupId, roleCode) <= 0L) break block10;
            JNDIUtil.close((DirContext)dirContext);
            return;
        }
        try {
            this.getGroupRepository().addRoleToGroup(groupId, roleCode);
        }
        catch (GroupNotFoundException | RoleNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to add the role (" + roleCode + ") to the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addUserToGroup(String groupName, String username) throws UserNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        DirContext dirContext;
        block12: {
            if (!this.capabilities.getSupportsGroupMemberAdministration()) {
                throw new ServiceUnavailableException("The group member administration capability is not supported for the user directory (" + this.getUserDirectoryId());
            }
            dirContext = null;
            try {
                dirContext = this.getDirContext(this.bindDN, this.bindPassword);
                LdapName userDN = this.getUserDN(dirContext, username);
                if (userDN == null) {
                    throw new UserNotFoundException(username);
                }
                LdapName groupDN = this.getGroupDN(dirContext, groupName);
                if (groupDN == null) {
                    throw new GroupNotFoundException(groupName);
                }
                Attributes attributes = dirContext.getAttributes(groupDN, this.groupMemberAttributeArray);
                BasicAttribute attribute = new BasicAttribute(this.groupMemberAttribute);
                if (attributes.get(this.groupMemberAttribute) != null) {
                    NamingEnumeration<?> groupMembers = attributes.get(this.groupMemberAttribute).getAll();
                    while (groupMembers.hasMore()) {
                        LdapName groupMemberDN = new LdapName((String)groupMembers.next());
                        if (!groupMemberDN.equals(userDN)) {
                            attribute.add(groupMemberDN.toString());
                            continue;
                        }
                        break block12;
                    }
                }
                attribute.add(userDN.toString());
                dirContext.modifyAttributes(groupDN, new ModificationItem[]{new ModificationItem(2, attribute)});
            }
            catch (GroupNotFoundException | UserNotFoundException e) {
                try {
                    throw e;
                    catch (Throwable e2) {
                        throw new ServiceUnavailableException("Failed to add the user (" + username + ") to the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                    }
                }
                catch (Throwable throwable) {
                    JNDIUtil.close(dirContext);
                    throw throwable;
                }
            }
            JNDIUtil.close((DirContext)dirContext);
            return;
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void adminChangePassword(String username, String newPassword, boolean expirePassword, boolean lockUser, boolean resetPasswordHistory, PasswordChangeReason reason) throws UserNotFoundException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsAdminChangePassword()) {
            throw new ServiceUnavailableException("The admin change password capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
            BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
            passwordAttribute.add(newPassword);
            modificationItems.add(new ModificationItem(2, passwordAttribute));
            dirContext.modifyAttributes(userDN, modificationItems.toArray(new ModificationItem[0]));
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to change the password for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void authenticate(String username, String password) throws AuthenticationFailedException, UserLockedException, ExpiredPasswordException, UserNotFoundException, ServiceUnavailableException {
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            DirContext userDirContext = null;
            try {
                userDirContext = this.getDirContext(userDN.toString(), password);
            }
            catch (Throwable e) {
                try {
                    if (e.getCause() instanceof AuthenticationException) {
                        throw new AuthenticationFailedException("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")");
                    }
                    logger.error("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
                    throw new AuthenticationFailedException("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
                }
                catch (Throwable throwable) {
                    JNDIUtil.close(userDirContext);
                    throw throwable;
                }
            }
            JNDIUtil.close((DirContext)userDirContext);
        }
        catch (AuthenticationFailedException | UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changePassword(String username, String password, String newPassword) throws AuthenticationFailedException, UserLockedException, ExistingPasswordException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsChangePassword()) {
            throw new ServiceUnavailableException("The change password capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new AuthenticationFailedException("Authentication failed while attempting to change the password for the user (" + username + ")");
            }
            DirContext userDirContext = null;
            try {
                userDirContext = this.getDirContext(userDN.toString(), password);
            }
            catch (Throwable e) {
                try {
                    if (e.getCause() instanceof AuthenticationException) {
                        throw new AuthenticationFailedException("Authentication failed while attempting to change the password for the user (" + username + ")");
                    }
                    logger.error("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
                    throw new AuthenticationFailedException("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
                }
                catch (Throwable throwable) {
                    JNDIUtil.close(userDirContext);
                    throw throwable;
                }
            }
            JNDIUtil.close((DirContext)userDirContext);
            ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
            BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
            passwordAttribute.add(newPassword);
            modificationItems.add(new ModificationItem(2, passwordAttribute));
            dirContext.modifyAttributes(userDN, modificationItems.toArray(new ModificationItem[0]));
        }
        catch (AuthenticationFailedException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to change the password for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createGroup(Group group) throws DuplicateGroupException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsGroupAdministration()) {
            throw new ServiceUnavailableException("The group administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, group.getName());
            if (groupDN != null) {
                throw new DuplicateGroupException(group.getName());
            }
            groupDN = new LdapName(this.groupNameAttribute + "=" + group.getName() + "," + this.groupBaseDN.toString());
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(new BasicAttribute("objectclass", "top"));
            attributes.put(new BasicAttribute("objectclass", this.groupObjectClass));
            if (this.groupObjectClass.equalsIgnoreCase("groupOfNames")) {
                attributes.put(new BasicAttribute(this.groupMemberAttribute, groupDN.toString()));
            }
            attributes.put(new BasicAttribute(this.groupNameAttribute, group.getName()));
            if (StringUtils.hasText((String)this.groupDescriptionAttribute)) {
                attributes.put(new BasicAttribute(this.groupDescriptionAttribute, StringUtils.hasText((String)group.getDescription()) ? group.getDescription() : ""));
            }
            dirContext.bind(groupDN, (Object)dirContext, (Attributes)attributes);
            group.setId(UuidCreator.getShortPrefixComb());
            this.getGroupRepository().saveAndFlush(group);
        }
        catch (DuplicateGroupException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to create the group (" + group.getName() + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createUser(User user, boolean expiredPassword, boolean userLocked) throws DuplicateUserException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsUserAdministration()) {
            throw new ServiceUnavailableException("The user administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, user.getUsername());
            if (userDN != null) {
                throw new DuplicateUserException(user.getUsername());
            }
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(new BasicAttribute("objectclass", "top"));
            attributes.put(new BasicAttribute("objectclass", this.userObjectClass));
            attributes.put(new BasicAttribute(this.userUsernameAttribute, user.getUsername()));
            if (StringUtils.hasText((String)this.userNameAttribute) && StringUtils.hasText((String)user.getName())) {
                attributes.put(new BasicAttribute(this.userNameAttribute, user.getName()));
            }
            if (StringUtils.hasText((String)this.userPreferredNameAttribute) && StringUtils.hasText((String)user.getPreferredName())) {
                attributes.put(new BasicAttribute(this.userPreferredNameAttribute, user.getPreferredName()));
            }
            if (StringUtils.hasText((String)this.userEmailAttribute) && StringUtils.hasText((String)user.getEmail())) {
                attributes.put(new BasicAttribute(this.userEmailAttribute, user.getEmail()));
            }
            if (StringUtils.hasText((String)this.userPhoneNumberAttribute) && StringUtils.hasText((String)user.getPhoneNumber())) {
                attributes.put(new BasicAttribute(this.userPhoneNumberAttribute, user.getPhoneNumber()));
            }
            if (StringUtils.hasText((String)this.userMobileNumberAttribute) && StringUtils.hasText((String)user.getMobileNumber())) {
                attributes.put(new BasicAttribute(this.userMobileNumberAttribute, user.getMobileNumber()));
            }
            attributes.put(new BasicAttribute("userPassword", StringUtils.hasText((String)user.getPassword()) ? user.getPassword() : ""));
            userDN = new LdapName(this.userUsernameAttribute + "=" + user.getUsername() + "," + this.userBaseDN.toString());
            dirContext.bind(userDN, (Object)dirContext, (Attributes)attributes);
        }
        catch (DuplicateUserException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to create the user (" + user.getUsername() + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteGroup(String groupName) throws GroupNotFoundException, ExistingGroupMembersException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsGroupAdministration()) {
            throw new ServiceUnavailableException("The group administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            LdapName lastGroupMember;
            Attribute attribute;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, groupName);
            if (groupDN == null) {
                throw new GroupNotFoundException(groupName);
            }
            Attributes attributes = dirContext.getAttributes(groupDN, this.groupMemberAttributeArray);
            if (attributes.get(this.groupMemberAttribute) != null && ((attribute = attributes.get(this.groupMemberAttribute)).size() == 1 ? !(lastGroupMember = new LdapName(String.valueOf(attribute.get(0)))).equals(groupDN) : attribute.size() > 1)) {
                throw new ExistingGroupMembersException(groupName);
            }
            dirContext.destroySubcontext(groupDN);
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            groupIdOptional.ifPresent(uuid -> this.getGroupRepository().deleteById((UUID)uuid));
        }
        catch (ExistingGroupMembersException | GroupNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to delete the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsUserAdministration()) {
            throw new ServiceUnavailableException("The user administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupMemberAttribute, userDN.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                Attributes attributes = searchResult.getAttributes();
                BasicAttribute attribute = new BasicAttribute(this.groupMemberAttribute);
                if (attributes.get(this.groupMemberAttribute) != null) {
                    NamingEnumeration<?> groupMembers = attributes.get(this.groupMemberAttribute).getAll();
                    while (groupMembers.hasMore()) {
                        LdapName groupMemberDN = new LdapName((String)groupMembers.next());
                        if (groupMemberDN.equals(userDN)) continue;
                        attribute.add(groupMemberDN.toString());
                    }
                }
                if (attribute.size() > 0) {
                    dirContext.modifyAttributes(new LdapName(searchResult.getNameInNamespace()), new ModificationItem[]{new ModificationItem(2, attribute)});
                    continue;
                }
                dirContext.modifyAttributes(new LdapName(searchResult.getNameInNamespace()), new ModificationItem[]{new ModificationItem(3, attribute)});
            }
            dirContext.destroySubcontext(userDN);
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to delete the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
    }

    @Override
    public List<User> findUsers(List<UserAttribute> userAttributes) throws InvalidAttributeException, ServiceUnavailableException {
        ArrayList<User> arrayList;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            Object searchFilter = "(objectClass=" + this.userObjectClass + ")";
            if (userAttributes.size() > 0) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("(&(objectClass=");
                buffer.append(this.userObjectClass);
                buffer.append(")");
                for (UserAttribute userAttribute : userAttributes) {
                    buffer.append("(");
                    buffer.append(userAttribute.getName());
                    buffer.append("=*");
                    buffer.append(userAttribute.getValue());
                    buffer.append("*)");
                }
                buffer.append(")");
                searchFilter = buffer.toString();
            }
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setCountLimit(this.maxFilteredUsers);
            ArrayList<User> users = new ArrayList<User>();
            searchResults = dirContext.search((Name)this.userBaseDN, (String)searchFilter, searchControls);
            while (searchResults.hasMore() && users.size() <= this.maxFilteredUsers) {
                users.add(this.buildUserFromSearchResult(searchResults.next()));
            }
            arrayList = users;
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to find the users for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    @Override
    public UserDirectoryCapabilities getCapabilities() {
        return this.capabilities;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getFunctionCodesForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        ArrayList<String> arrayList;
        ArrayList<String> groupNames;
        NamingEnumeration<SearchResult> searchResults;
        DirContext dirContext;
        block8: {
            dirContext = null;
            searchResults = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupMemberAttribute, userDN.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            groupNames = new ArrayList<String>();
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                if (searchResult.getAttributes().get(this.groupNameAttribute) == null) continue;
                groupNames.add(String.valueOf(searchResult.getAttributes().get(this.groupNameAttribute).get()).toLowerCase());
            }
            if (!groupNames.isEmpty()) break block8;
            arrayList = new ArrayList();
            JNDIUtil.close(searchResults);
            JNDIUtil.close((DirContext)dirContext);
            return arrayList;
        }
        try {
            arrayList = this.getGroupRepository().getFunctionCodesByUserDirectoryIdAndGroupNames(this.getUserDirectoryId(), groupNames);
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the function codes for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    @Override
    public Group getGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        NamingEnumeration<SearchResult> searchResults;
        DirContext dirContext;
        block6: {
            dirContext = null;
            searchResults = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupNameAttribute, groupName);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            if (!searchResults.hasMore()) break block6;
            Group group = this.buildGroupFromSearchResult(searchResults.next());
            JNDIUtil.close(searchResults);
            JNDIUtil.close((DirContext)dirContext);
            return group;
        }
        try {
            try {
                throw new GroupNotFoundException(groupName);
            }
            catch (GroupNotFoundException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServiceUnavailableException("Failed to retrieve the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
        }
        catch (Throwable throwable) {
            JNDIUtil.close(searchResults);
            JNDIUtil.close(dirContext);
            throw throwable;
        }
    }

    @Override
    public List<String> getGroupNames() throws ServiceUnavailableException {
        ArrayList<String> arrayList;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = String.format("(objectClass=%s)", this.groupObjectClass);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setCountLimit(this.maxFilteredGroups);
            searchControls.setReturningAttributes(new String[]{this.groupNameAttribute});
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            ArrayList<String> groupNames = new ArrayList<String>();
            while (searchResults.hasMore() && groupNames.size() <= this.maxFilteredGroups) {
                SearchResult searchResult = searchResults.next();
                Attributes attributes = searchResult.getAttributes();
                groupNames.add(String.valueOf(attributes.get(this.groupNameAttribute).get()));
            }
            arrayList = groupNames;
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to retrieve the group names for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getGroupNamesForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        ArrayList<String> arrayList;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupMemberAttribute, userDN.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            ArrayList<String> groupNames = new ArrayList<String>();
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                if (searchResult.getAttributes().get(this.groupNameAttribute) == null) continue;
                groupNames.add(String.valueOf(searchResult.getAttributes().get(this.groupNameAttribute).get()));
            }
            arrayList = groupNames;
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the names of the groups the user (" + username + ") is a member of for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    @Override
    public List<Group> getGroups() throws ServiceUnavailableException {
        ArrayList<Group> arrayList;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = String.format("(objectClass=%s)", this.groupObjectClass);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setCountLimit(this.maxFilteredGroups);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            ArrayList<Group> groups = new ArrayList<Group>();
            while (searchResults.hasMore() && groups.size() <= this.maxFilteredGroups) {
                groups.add(this.buildGroupFromSearchResult(searchResults.next()));
            }
            arrayList = groups;
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to retrieve the groups for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    @Override
    public Groups getGroups(String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws ServiceUnavailableException {
        Groups groups;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = StringUtils.hasText((String)filter) ? String.format("(&(objectClass=%s)(%s=*%s*))", this.groupObjectClass, this.groupNameAttribute, filter) : String.format("(objectClass=%s)", this.groupObjectClass);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setCountLimit(this.maxFilteredGroups);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            List<Group> groups2 = new ArrayList<Group>();
            while (searchResults.hasMore() && groups2.size() <= this.maxFilteredGroups) {
                groups2.add(this.buildGroupFromSearchResult(searchResults.next()));
            }
            if (sortDirection == SortDirection.ASCENDING) {
                groups2.sort(Comparator.comparing(Group::getName));
            } else {
                groups2.sort((group1, group2) -> group2.getName().compareTo(group1.getName()));
            }
            long totalGroups = groups2.size();
            if (pageIndex != null && pageSize != null) {
                int toIndex = pageIndex * pageSize + pageSize;
                groups2 = groups2.subList(pageIndex * pageSize, Math.min(toIndex, groups2.size()));
            }
            groups = new Groups(this.getUserDirectoryId(), groups2, totalGroups, filter, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to retrieve the filtered groups for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return groups;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Group> getGroupsForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        ArrayList<Group> arrayList;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupMemberAttribute, userDN.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            ArrayList<Group> groups = new ArrayList<Group>();
            while (searchResults.hasMore()) {
                groups.add(this.buildGroupFromSearchResult(searchResults.next()));
            }
            arrayList = groups;
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the groups the user is a member of (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    @Override
    public List<GroupMember> getMembersForGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        NamingEnumeration<SearchResult> searchResults;
        DirContext dirContext;
        block9: {
            dirContext = null;
            searchResults = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupNameAttribute, groupName);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            if (!searchResults.hasMore()) break block9;
            SearchResult searchResult = searchResults.next();
            ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
            Attribute attribute = searchResult.getAttributes().get(this.groupMemberAttribute);
            if (attribute != null) {
                block6: for (int i = 0; i < attribute.size() && i < this.maxFilteredGroupMembers; ++i) {
                    LdapName groupMemberDn = new LdapName(String.valueOf(attribute.get(i)));
                    for (Rdn rdn : groupMemberDn.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase(this.userUsernameAttribute)) continue;
                        groupMembers.add(new GroupMember(this.getUserDirectoryId(), groupName, GroupMemberType.USER, String.valueOf(rdn.getValue())));
                        continue block6;
                    }
                }
            }
            ArrayList<GroupMember> arrayList = groupMembers;
            JNDIUtil.close(searchResults);
            JNDIUtil.close((DirContext)dirContext);
            return arrayList;
        }
        try {
            try {
                throw new GroupNotFoundException(groupName);
            }
            catch (GroupNotFoundException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServiceUnavailableException("Failed to retrieve the members for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
        }
        catch (Throwable throwable) {
            JNDIUtil.close(searchResults);
            JNDIUtil.close(dirContext);
            throw throwable;
        }
    }

    @Override
    public GroupMembers getMembersForGroup(String groupName, String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws GroupNotFoundException, ServiceUnavailableException {
        NamingEnumeration<SearchResult> searchResults;
        DirContext dirContext;
        block14: {
            dirContext = null;
            searchResults = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            if (StringUtils.hasText((String)filter)) {
                filter = filter.toLowerCase();
            }
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupNameAttribute, groupName);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            if (!searchResults.hasMore()) break block14;
            SearchResult searchResult = searchResults.next();
            List<GroupMember> groupMembers = new ArrayList<GroupMember>();
            Attribute attribute = searchResult.getAttributes().get(this.groupMemberAttribute);
            if (attribute != null) {
                block6: for (int i = 0; i < attribute.size(); ++i) {
                    LdapName groupMemberDn = new LdapName(String.valueOf(attribute.get(i)));
                    for (Rdn rdn : groupMemberDn.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase(this.userUsernameAttribute)) continue;
                        if (!StringUtils.hasText((String)filter)) {
                            groupMembers.add(new GroupMember(this.getUserDirectoryId(), groupName, GroupMemberType.USER, String.valueOf(rdn.getValue())));
                            continue block6;
                        }
                        String username = String.valueOf(rdn.getValue());
                        if (!username.contains(filter)) continue block6;
                        groupMembers.add(new GroupMember(this.getUserDirectoryId(), groupName, GroupMemberType.USER, String.valueOf(rdn.getValue())));
                        continue block6;
                    }
                }
            }
            if (sortDirection == SortDirection.ASCENDING) {
                groupMembers.sort(Comparator.comparing(GroupMember::getMemberName));
            } else {
                groupMembers.sort((groupMember1, groupMember2) -> groupMember2.getMemberName().compareTo(groupMember1.getMemberName()));
            }
            long totalGroupMembers = groupMembers.size();
            if (pageIndex != null && pageSize != null) {
                pageSize = Math.min(pageSize, this.maxFilteredGroupMembers);
                int toIndex = pageIndex * pageSize + pageSize;
                groupMembers = groupMembers.subList(pageIndex * pageSize, Math.min(toIndex, groupMembers.size()));
            }
            GroupMembers groupMembers2 = new GroupMembers(this.getUserDirectoryId(), groupName, groupMembers, totalGroupMembers, filter, sortDirection, pageIndex, pageSize);
            JNDIUtil.close(searchResults);
            JNDIUtil.close((DirContext)dirContext);
            return groupMembers2;
        }
        try {
            try {
                throw new GroupNotFoundException(groupName);
            }
            catch (GroupNotFoundException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServiceUnavailableException("Failed to retrieve the filtered members for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
        }
        catch (Throwable throwable) {
            JNDIUtil.close(searchResults);
            JNDIUtil.close(dirContext);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getRoleCodesForGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        ArrayList<String> arrayList;
        DirContext dirContext;
        block7: {
            dirContext = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, groupName);
            if (groupDN == null) {
                throw new GroupNotFoundException(groupName);
            }
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (!groupIdOptional.isPresent()) break block7;
            List<String> list = this.getGroupRepository().getRoleCodesByGroupId(groupIdOptional.get());
            JNDIUtil.close((DirContext)dirContext);
            return list;
        }
        try {
            arrayList = new ArrayList<String>();
        }
        catch (GroupNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the role codes for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getRoleCodesForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        ArrayList<String> arrayList;
        ArrayList<String> groupNames;
        NamingEnumeration<SearchResult> searchResults;
        DirContext dirContext;
        block8: {
            dirContext = null;
            searchResults = null;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupMemberAttribute, userDN.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            groupNames = new ArrayList<String>();
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                if (searchResult.getAttributes().get(this.groupNameAttribute) == null) continue;
                groupNames.add(String.valueOf(searchResult.getAttributes().get(this.groupNameAttribute).get()).toLowerCase());
            }
            if (!groupNames.isEmpty()) break block8;
            arrayList = new ArrayList();
            JNDIUtil.close(searchResults);
            JNDIUtil.close((DirContext)dirContext);
            return arrayList;
        }
        try {
            arrayList = this.getGroupRepository().getRoleCodesByUserDirectoryIdAndGroupNames(this.getUserDirectoryId(), groupNames);
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the role codes for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<GroupRole> getRolesForGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        ArrayList<GroupRole> arrayList;
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, groupName);
            if (groupDN == null) {
                throw new GroupNotFoundException(groupName);
            }
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            ArrayList<GroupRole> groupRoles = new ArrayList<GroupRole>();
            if (groupIdOptional.isPresent()) {
                for (String roleCode : this.getGroupRepository().getRoleCodesByGroupId(groupIdOptional.get())) {
                    groupRoles.add(new GroupRole(this.getUserDirectoryId(), groupName, roleCode));
                }
            }
            arrayList = groupRoles;
        }
        catch (GroupNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the roles for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User getUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        User user;
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            User user2 = this.getUser(dirContext, username);
            if (user2 == null) {
                throw new UserNotFoundException(username);
            }
            user = user2;
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
        return user;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getUserName(String username) throws UserNotFoundException, ServiceUnavailableException {
        String string;
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            User user = this.getUser(dirContext, username);
            if (user == null) {
                throw new UserNotFoundException(username);
            }
            StringBuilder buffer = new StringBuilder(user.getName());
            if (StringUtils.hasText((String)user.getPreferredName())) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(user.getPreferredName());
            }
            string = buffer.toString();
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to retrieve the name of the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
        return string;
    }

    @Override
    public List<User> getUsers() throws ServiceUnavailableException {
        ArrayList<User> arrayList;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = String.format("(objectClass=%s)", this.userObjectClass);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setCountLimit(this.maxFilteredUsers);
            ArrayList<User> users = new ArrayList<User>();
            searchResults = dirContext.search((Name)this.userBaseDN, searchFilter, searchControls);
            while (searchResults.hasMore() && users.size() <= this.maxFilteredUsers) {
                users.add(this.buildUserFromSearchResult(searchResults.next()));
            }
            arrayList = users;
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to retrieve the users for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return arrayList;
    }

    @Override
    public Users getUsers(String filter, UserSortBy sortBy, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws ServiceUnavailableException {
        Users users;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = StringUtils.hasText((String)filter) ? String.format("(&(objectClass=%s)(|(%s=*%s*)(%s=*%s*)(%s=*%s*)))", this.userObjectClass, this.userUsernameAttribute, filter, this.userNameAttribute, filter, this.userPreferredNameAttribute, filter) : String.format("(objectClass=%s)", this.userObjectClass);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setCountLimit(this.maxFilteredUsers);
            List<User> users2 = new ArrayList<User>();
            searchResults = dirContext.search((Name)this.userBaseDN, searchFilter, searchControls);
            while (searchResults.hasMore() && users2.size() <= this.maxFilteredUsers) {
                users2.add(this.buildUserFromSearchResult(searchResults.next()));
            }
            if (sortDirection == SortDirection.ASCENDING) {
                if (sortBy == UserSortBy.USERNAME) {
                    users2.sort(Comparator.comparing(User::getUsername));
                } else if (sortBy == UserSortBy.NAME) {
                    users2.sort(Comparator.comparing(User::getName));
                } else if (sortBy == UserSortBy.PREFERRED_NAME) {
                    users2.sort(Comparator.comparing(User::getPreferredName));
                }
            } else if (sortBy == UserSortBy.USERNAME) {
                users2.sort((user1, user2) -> user2.getUsername().compareTo(user1.getUsername()));
            } else if (sortBy == UserSortBy.NAME) {
                users2.sort((user1, user2) -> user2.getName().compareTo(user1.getName()));
            } else if (sortBy == UserSortBy.PREFERRED_NAME) {
                users2.sort((user1, user2) -> user2.getPreferredName().compareTo(user1.getPreferredName()));
            }
            long totalUsers = users2.size();
            if (pageIndex != null && pageSize != null) {
                int toIndex = pageIndex * pageSize + pageSize;
                users2 = users2.subList(pageIndex * pageSize, Math.min(toIndex, users2.size()));
            }
            users = new Users(this.getUserDirectoryId(), users2, totalUsers, filter, sortBy, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to retrieve the filtered users for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return users;
    }

    @Override
    public boolean isExistingUser(String username) throws ServiceUnavailableException {
        boolean bl;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.userObjectClass, this.userUsernameAttribute, username);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.baseDN, searchFilter, searchControls);
            bl = searchResults.hasMore();
        }
        catch (Throwable e) {
            try {
                throw new ServiceUnavailableException("Failed to check whether the user (" + username + ") is an existing user for the user directory (" + this.getUserDirectoryId() + ")", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.close(searchResults);
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close(searchResults);
        JNDIUtil.close((DirContext)dirContext);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUserInGroup(String groupName, String username) throws UserNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        boolean bl;
        DirContext dirContext;
        block10: {
            boolean bl2;
            dirContext = null;
            try {
                dirContext = this.getDirContext(this.bindDN, this.bindPassword);
                LdapName userDN = this.getUserDN(dirContext, username);
                if (userDN == null) {
                    throw new UserNotFoundException(username);
                }
                LdapName groupDN = this.getGroupDN(dirContext, groupName);
                if (groupDN == null) {
                    throw new GroupNotFoundException(groupName);
                }
                Attributes attributes = dirContext.getAttributes(groupDN, this.groupMemberAttributeArray);
                if (attributes.get(this.groupMemberAttribute) != null) {
                    NamingEnumeration<?> attributeValues = attributes.get(this.groupMemberAttribute).getAll();
                    while (attributeValues.hasMore()) {
                        LdapName memberDN = new LdapName((String)attributeValues.next());
                        if (!memberDN.equals(userDN)) continue;
                        bl = true;
                        break block10;
                    }
                }
                bl2 = false;
            }
            catch (GroupNotFoundException | UserNotFoundException e) {
                try {
                    throw e;
                    catch (Throwable e2) {
                        throw new ServiceUnavailableException("Failed to check if the user (" + username + ") is in the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                    }
                }
                catch (Throwable throwable) {
                    JNDIUtil.close(dirContext);
                    throw throwable;
                }
            }
            JNDIUtil.close((DirContext)dirContext);
            return bl2;
        }
        JNDIUtil.close((DirContext)dirContext);
        return bl;
    }

    @Override
    public void removeMemberFromGroup(String groupName, GroupMemberType memberType, String memberName) throws GroupNotFoundException, GroupMemberNotFoundException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsGroupMemberAdministration()) {
            throw new ServiceUnavailableException("The group member administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        if (memberType != GroupMemberType.USER) {
            throw new ServiceUnavailableException("Unsupported group member type (" + memberType.description() + ")");
        }
        try {
            this.removeUserFromGroup(groupName, memberName);
        }
        catch (UserNotFoundException e) {
            throw new GroupMemberNotFoundException(memberType, memberName);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeRoleFromGroup(String groupName, String roleCode) throws GroupNotFoundException, GroupRoleNotFoundException, ServiceUnavailableException {
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, groupName);
            if (groupDN == null) {
                throw new GroupNotFoundException(groupName);
            }
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (!groupIdOptional.isPresent()) throw new GroupRoleNotFoundException(roleCode);
            if (this.getGroupRepository().removeRoleFromGroup(groupIdOptional.get(), roleCode) == 0) {
                throw new GroupRoleNotFoundException(roleCode);
            }
        }
        catch (GroupNotFoundException | GroupRoleNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to remove the role (" + roleCode + ") from the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeUserFromGroup(String groupName, String username) throws UserNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            LdapName groupDN = this.getGroupDN(dirContext, groupName);
            if (groupDN == null) {
                throw new GroupNotFoundException(groupName);
            }
            Attributes attributes = dirContext.getAttributes(groupDN, this.groupMemberAttributeArray);
            BasicAttribute attribute = new BasicAttribute(this.groupMemberAttribute);
            if (attributes.get(this.groupMemberAttribute) != null) {
                NamingEnumeration<?> groupMembers = attributes.get(this.groupMemberAttribute).getAll();
                while (groupMembers.hasMore()) {
                    LdapName groupMemberDN = new LdapName((String)groupMembers.next());
                    if (groupMemberDN.equals(userDN)) continue;
                    attribute.add(groupMemberDN.toString());
                }
            }
            if (attribute.size() > 0) {
                dirContext.modifyAttributes(groupDN, new ModificationItem[]{new ModificationItem(2, attribute)});
            } else {
                dirContext.modifyAttributes(groupDN, new ModificationItem[]{new ModificationItem(3, attribute)});
            }
        }
        catch (GroupNotFoundException | UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to remove the user (" + username + ") from the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void resetPassword(String username, String newPassword) throws UserNotFoundException, UserLockedException, ExistingPasswordException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsChangePassword()) {
            throw new ServiceUnavailableException("The change password capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, username);
            if (userDN == null) {
                throw new UserNotFoundException(username);
            }
            ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
            BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
            passwordAttribute.add(newPassword);
            modificationItems.add(new ModificationItem(2, passwordAttribute));
            dirContext.modifyAttributes(userDN, modificationItems.toArray(new ModificationItem[0]));
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to reset the password for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateGroup(Group group) throws GroupNotFoundException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsGroupAdministration()) {
            throw new ServiceUnavailableException("The group administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            Optional<UUID> groupIdOptional;
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName groupDN = this.getGroupDN(dirContext, group.getName());
            if (groupDN == null) {
                throw new GroupNotFoundException(group.getName());
            }
            ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
            if (StringUtils.hasText((String)this.groupDescriptionAttribute)) {
                modificationItems.add(new ModificationItem(2, new BasicAttribute(this.groupDescriptionAttribute, StringUtils.hasText((String)group.getDescription()) ? group.getDescription() : "")));
            }
            if (modificationItems.size() > 0) {
                dirContext.modifyAttributes(groupDN, modificationItems.toArray(new ModificationItem[0]));
            }
            if ((groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), group.getName())).isEmpty()) {
                group.setId(UuidCreator.getShortPrefixComb());
            } else {
                group.setId(groupIdOptional.get());
            }
            this.getGroupRepository().saveAndFlush(group);
        }
        catch (GroupNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to update the group (" + group.getName() + ") for the user directory (" + this.getUserDirectoryId() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateUser(User user, boolean expirePassword, boolean lockUser) throws UserNotFoundException, ServiceUnavailableException {
        if (!this.capabilities.getSupportsUserAdministration()) {
            throw new ServiceUnavailableException("The user administration capability is not supported for the user directory (" + this.getUserDirectoryId());
        }
        DirContext dirContext = null;
        try {
            dirContext = this.getDirContext(this.bindDN, this.bindPassword);
            LdapName userDN = this.getUserDN(dirContext, user.getUsername());
            if (userDN == null) {
                throw new UserNotFoundException(user.getUsername());
            }
            ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
            if (StringUtils.hasText((String)this.userNameAttribute)) {
                if (StringUtils.hasText((String)user.getName())) {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userNameAttribute, user.getName())));
                } else {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userNameAttribute)));
                }
            }
            if (StringUtils.hasText((String)this.userPreferredNameAttribute)) {
                if (StringUtils.hasText((String)user.getPreferredName())) {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userPreferredNameAttribute, user.getPreferredName())));
                } else {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userPreferredNameAttribute)));
                }
            }
            if (StringUtils.hasText((String)this.userEmailAttribute)) {
                if (StringUtils.hasText((String)user.getEmail())) {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userEmailAttribute, user.getEmail())));
                } else {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userEmailAttribute)));
                }
            }
            if (StringUtils.hasText((String)this.userPhoneNumberAttribute)) {
                if (StringUtils.hasText((String)user.getPhoneNumber())) {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userPhoneNumberAttribute, user.getPhoneNumber())));
                } else {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userPhoneNumberAttribute)));
                }
            }
            if (StringUtils.hasText((String)this.userMobileNumberAttribute)) {
                if (StringUtils.hasText((String)user.getMobileNumber())) {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userMobileNumberAttribute, user.getMobileNumber())));
                } else {
                    modificationItems.add(new ModificationItem(2, new BasicAttribute(this.userMobileNumberAttribute)));
                }
            }
            if (StringUtils.hasText((String)user.getPassword())) {
                modificationItems.add(new ModificationItem(2, new BasicAttribute("userPassword", user.getPassword())));
            }
            if (modificationItems.size() > 0) {
                dirContext.modifyAttributes(userDN, modificationItems.toArray(new ModificationItem[0]));
            }
        }
        catch (UserNotFoundException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ServiceUnavailableException("Failed to update the user (" + user.getUsername() + ") for the user directory (" + this.getUserDirectoryId() + "): " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.close(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.close((DirContext)dirContext);
    }

    private Group buildGroupFromSearchResult(SearchResult searchResult) throws NamingException {
        Attributes attributes = searchResult.getAttributes();
        Group group = new Group(String.valueOf(attributes.get(this.groupNameAttribute).get()));
        group.setId(null);
        group.setUserDirectoryId(this.getUserDirectoryId());
        if (StringUtils.hasText((String)this.groupDescriptionAttribute) && attributes.get(this.groupDescriptionAttribute) != null) {
            group.setDescription(String.valueOf(attributes.get(this.groupDescriptionAttribute).get()));
        } else {
            group.setDescription("");
        }
        return group;
    }

    private User buildUserFromSearchResult(SearchResult searchResult) throws NamingException {
        Attributes attributes = searchResult.getAttributes();
        User user = new User();
        user.setUsername(String.valueOf(attributes.get(this.userUsernameAttribute).get()));
        user.setUserDirectoryId(this.getUserDirectoryId());
        user.setStatus(UserStatus.ACTIVE);
        user.setPassword("");
        if (StringUtils.hasText((String)this.userNameAttribute) && attributes.get(this.userNameAttribute) != null) {
            user.setName(String.valueOf(attributes.get(this.userNameAttribute).get()));
        } else {
            user.setName("");
        }
        if (StringUtils.hasText((String)this.userPreferredNameAttribute) && attributes.get(this.userPreferredNameAttribute) != null) {
            user.setPreferredName(String.valueOf(attributes.get(this.userPreferredNameAttribute).get()));
        } else {
            user.setPreferredName("");
        }
        if (StringUtils.hasText((String)this.userPhoneNumberAttribute) && attributes.get(this.userPhoneNumberAttribute) != null) {
            user.setPhoneNumber(String.valueOf(attributes.get(this.userPhoneNumberAttribute).get()));
        } else {
            user.setPhoneNumber("");
        }
        if (StringUtils.hasText((String)this.userMobileNumberAttribute) && attributes.get(this.userMobileNumberAttribute) != null) {
            user.setMobileNumber(String.valueOf(attributes.get(this.userMobileNumberAttribute).get()));
        } else {
            user.setMobileNumber("");
        }
        if (StringUtils.hasText((String)this.userEmailAttribute) && attributes.get(this.userEmailAttribute) != null) {
            user.setEmail(String.valueOf(attributes.get(this.userEmailAttribute).get()));
        } else {
            user.setEmail("");
        }
        return user;
    }

    private DirContext getDirContext(String userDN, String password) throws ServiceUnavailableException {
        try {
            Object url = this.useSSL ? "ldaps://" : "ldap://";
            url = (String)url + this.host;
            url = (String)url + ":";
            url = (String)url + this.port;
            String connectionType = "simple";
            Hashtable<String, Object> environment = new Hashtable<String, Object>();
            environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            environment.put("java.naming.provider.url", url);
            environment.put("java.naming.security.authentication", connectionType);
            environment.put("java.naming.security.principal", userDN);
            environment.put("java.naming.security.credentials", password);
            return new InitialDirContext(environment);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException(String.format("Failed to retrieve the JNDI directory context for the user directory (%s)", this.getUserDirectoryId()), e);
        }
    }

    private LdapName getGroupDN(DirContext dirContext, String groupName) throws ServiceUnavailableException {
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            ArrayList<LdapName> groupDNs = new ArrayList<LdapName>();
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.groupObjectClass, this.groupNameAttribute, groupName);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setReturningAttributes(EMPTY_ATTRIBUTE_LIST);
            searchResults = dirContext.search((Name)this.groupBaseDN, searchFilter, searchControls);
            while (searchResults.hasMore()) {
                groupDNs.add(new LdapName(searchResults.next().getNameInNamespace().toLowerCase()));
            }
            if (groupDNs.size() == 0) {
                LdapName ldapName = null;
                return ldapName;
            }
            if (groupDNs.size() == 1) {
                LdapName ldapName = (LdapName)groupDNs.get(0);
                return ldapName;
            }
            try {
                StringBuilder buffer = new StringBuilder();
                for (LdapName groupDN : groupDNs) {
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append("(").append(groupDN).append(")");
                }
                throw new ServiceUnavailableException(String.format("Found multiple groups (%d) with the name of the group (%s) with DNs %s", groupDNs.size(), groupName, buffer.toString()));
            }
            catch (Throwable e) {
                throw new ServiceUnavailableException(String.format("Failed to retrieve the DN for the group (%s) from the LDAP directory (%s:%d)", groupName, this.host, this.port), e);
            }
        }
        finally {
            JNDIUtil.close(searchResults);
        }
    }

    private User getUser(DirContext dirContext, String username) throws ServiceUnavailableException {
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            ArrayList<User> users = new ArrayList<User>();
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.userObjectClass, this.userUsernameAttribute, username);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchResults = dirContext.search((Name)this.baseDN, searchFilter, searchControls);
            while (searchResults.hasMore()) {
                users.add(this.buildUserFromSearchResult(searchResults.next()));
            }
            if (users.size() == 0) {
                User user = null;
                return user;
            }
            if (users.size() == 1) {
                User user = (User)users.get(0);
                return user;
            }
            try {
                StringBuilder buffer = new StringBuilder();
                for (User user : users) {
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append("(").append(user.getId()).append(")");
                }
                throw new ServiceUnavailableException(String.format("Found multiple users (%d) with the username (%s) with DNs %s", users.size(), username, buffer.toString()));
            }
            catch (Throwable e) {
                throw new ServiceUnavailableException(String.format("Failed to retrieve the details for the user (%s) from the LDAP directory (%s:%d)", username, this.host, this.port), e);
            }
        }
        finally {
            JNDIUtil.close(searchResults);
        }
    }

    private LdapName getUserDN(DirContext dirContext, String username) throws ServiceUnavailableException {
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            ArrayList<LdapName> userDNs = new ArrayList<LdapName>();
            String searchFilter = String.format("(&(objectClass=%s)(%s=%s))", this.userObjectClass, this.userUsernameAttribute, username);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningObjFlag(false);
            searchControls.setReturningAttributes(EMPTY_ATTRIBUTE_LIST);
            searchResults = dirContext.search((Name)this.baseDN, searchFilter, searchControls);
            while (searchResults.hasMore()) {
                userDNs.add(new LdapName(searchResults.next().getNameInNamespace().toLowerCase()));
            }
            if (userDNs.size() == 0) {
                LdapName ldapName = null;
                return ldapName;
            }
            if (userDNs.size() == 1) {
                LdapName ldapName = (LdapName)userDNs.get(0);
                return ldapName;
            }
            try {
                StringBuilder buffer = new StringBuilder();
                for (LdapName userDN : userDNs) {
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append("(").append(userDN).append(")");
                }
                throw new ServiceUnavailableException(String.format("Found multiple users (%d) with the username (%s) with DNs %s", userDNs.size(), username, buffer.toString()));
            }
            catch (Throwable e) {
                throw new ServiceUnavailableException(String.format("Failed to retrieve the DN for the user (%s) from the LDAP directory (%s:%d)", username, this.host, this.port), e);
            }
        }
        finally {
            JNDIUtil.close(searchResults);
        }
    }
}

