/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.core.util.PasswordUtil;
import africa.absa.inception.security.AuthenticationFailedException;
import africa.absa.inception.security.DuplicateGroupException;
import africa.absa.inception.security.DuplicateUserException;
import africa.absa.inception.security.ExistingGroupMembersException;
import africa.absa.inception.security.ExistingPasswordException;
import africa.absa.inception.security.ExpiredPasswordException;
import africa.absa.inception.security.Group;
import africa.absa.inception.security.GroupMember;
import africa.absa.inception.security.GroupMemberNotFoundException;
import africa.absa.inception.security.GroupMemberType;
import africa.absa.inception.security.GroupMembers;
import africa.absa.inception.security.GroupNotFoundException;
import africa.absa.inception.security.GroupRepository;
import africa.absa.inception.security.GroupRole;
import africa.absa.inception.security.GroupRoleNotFoundException;
import africa.absa.inception.security.Groups;
import africa.absa.inception.security.InvalidAttributeException;
import africa.absa.inception.security.PasswordChangeReason;
import africa.absa.inception.security.RoleNotFoundException;
import africa.absa.inception.security.RoleRepository;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserAttribute;
import africa.absa.inception.security.UserDirectoryBase;
import africa.absa.inception.security.UserDirectoryCapabilities;
import africa.absa.inception.security.UserDirectoryParameter;
import africa.absa.inception.security.UserLockedException;
import africa.absa.inception.security.UserNotFoundException;
import africa.absa.inception.security.UserRepository;
import africa.absa.inception.security.UserSortBy;
import africa.absa.inception.security.UserStatus;
import africa.absa.inception.security.Users;
import com.github.f4b6a3.uuid.UuidCreator;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.StringUtils;

public class InternalUserDirectory
extends UserDirectoryBase {
    private static final int DEFAULT_MAX_FILTERED_GROUPS = 100;
    private static final int DEFAULT_MAX_FILTERED_GROUP_MEMBERS = 100;
    private static final int DEFAULT_MAX_FILTERED_USERS = 100;
    private static final int DEFAULT_MAX_PASSWORD_ATTEMPTS = 5;
    private static final int DEFAULT_PASSWORD_EXPIRY_MONTHS = 3;
    private static final int DEFAULT_PASSWORD_HISTORY_MONTHS = 12;
    private static final UserDirectoryCapabilities INTERNAL_USER_DIRECTORY_CAPABILITIES = new UserDirectoryCapabilities(true, true, true, true, true, true, true, true);
    private final int maxFilteredGroupMembers;
    private final int maxFilteredGroups;
    private final int maxFilteredUsers;
    private final int maxPasswordAttempts;
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder(10, new SecureRandom());
    private final int passwordExpiryMonths;
    private final int passwordHistoryMonths;

    public InternalUserDirectory(UUID userDirectoryId, List<UserDirectoryParameter> parameters, GroupRepository groupRepository, UserRepository userRepository, RoleRepository roleRepository) throws ServiceUnavailableException {
        super(userDirectoryId, parameters, groupRepository, userRepository, roleRepository);
        try {
            this.maxPasswordAttempts = UserDirectoryParameter.contains(parameters, "MaxPasswordAttempts") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxPasswordAttempts") : 5;
            this.passwordExpiryMonths = UserDirectoryParameter.contains(parameters, "PasswordExpiryMonths") ? UserDirectoryParameter.getIntegerValue(parameters, "PasswordExpiryMonths") : 3;
            this.passwordHistoryMonths = UserDirectoryParameter.contains(parameters, "PasswordHistoryMonths") ? UserDirectoryParameter.getIntegerValue(parameters, "PasswordHistoryMonths") : 12;
            this.maxFilteredUsers = UserDirectoryParameter.contains(parameters, "MaxFilteredUsers") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxFilteredUsers") : 100;
            this.maxFilteredGroups = UserDirectoryParameter.contains(parameters, "MaxFilteredGroups") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxFilteredGroups") : 100;
            this.maxFilteredGroupMembers = UserDirectoryParameter.contains(parameters, "MaxFilteredGroupMembers") ? UserDirectoryParameter.getIntegerValue(parameters, "MaxFilteredGroupMembers") : 100;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to initialize the user directory (" + userDirectoryId + ")", e);
        }
    }

    @Override
    public void addMemberToGroup(String groupName, GroupMemberType memberType, String memberName) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        if (memberType != GroupMemberType.USER) {
            throw new ServiceUnavailableException("Unsupported group member type (" + memberType.description() + ")");
        }
        if (this.isUserInGroup(groupName, memberName)) {
            return;
        }
        this.addUserToGroup(groupName, memberName);
    }

    @Override
    public void addRoleToGroup(String groupName, String roleCode) throws GroupNotFoundException, RoleNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            if (!this.getRoleRepository().existsById(roleCode)) {
                throw new RoleNotFoundException(roleCode);
            }
            if (this.getGroupRepository().countGroupRole(groupIdOptional.get(), roleCode) > 0L) {
                return;
            }
            this.getGroupRepository().addRoleToGroup(groupIdOptional.get(), roleCode);
        }
        catch (GroupNotFoundException | RoleNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to add the role (" + roleCode + ") to the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void addUserToGroup(String groupName, String username) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            this.getGroupRepository().addUserToGroup(groupIdOptional.get(), userIdOptional.get());
        }
        catch (GroupNotFoundException | UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to add the user (" + username + ") to the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void adminChangePassword(String username, String newPassword, boolean expirePassword, boolean lockUser, boolean resetPasswordHistory, PasswordChangeReason reason) throws UserNotFoundException, ServiceUnavailableException {
        try {
            LocalDateTime passwordExpiry;
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            String encodedNewPassword = this.passwordEncoder.encode((CharSequence)newPassword);
            int passwordAttempts = 0;
            if (lockUser) {
                passwordAttempts = this.maxPasswordAttempts;
            }
            if (expirePassword) {
                passwordExpiry = LocalDateTime.now();
            } else {
                passwordExpiry = LocalDateTime.now();
                passwordExpiry = passwordExpiry.plus(this.passwordExpiryMonths, ChronoUnit.MONTHS);
            }
            this.getUserRepository().changePassword(userIdOptional.get(), encodedNewPassword, passwordAttempts, Optional.of(passwordExpiry));
            if (resetPasswordHistory) {
                this.getUserRepository().resetPasswordHistory(userIdOptional.get());
            }
            this.getUserRepository().savePasswordInPasswordHistory(userIdOptional.get(), encodedNewPassword);
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to change the password for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void authenticate(String username, String password) throws AuthenticationFailedException, UserLockedException, ExpiredPasswordException, UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<User> userOptional = this.getUserRepository().findByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            User user = userOptional.get();
            if (user.getPasswordAttempts() != null && user.getPasswordAttempts() >= this.maxPasswordAttempts) {
                throw new UserLockedException(username);
            }
            if (!this.passwordEncoder.matches((CharSequence)password, user.getPassword())) {
                if (user.getPasswordAttempts() != null && user.getPasswordAttempts() != -1) {
                    this.getUserRepository().incrementPasswordAttempts(user.getId());
                }
                throw new AuthenticationFailedException("Authentication failed for the user (" + username + ")");
            }
            if (user.hasPasswordExpired()) {
                throw new ExpiredPasswordException(username);
            }
        }
        catch (AuthenticationFailedException | ExpiredPasswordException | UserLockedException | UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to authenticate the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void changePassword(String username, String password, String newPassword) throws AuthenticationFailedException, UserLockedException, ExistingPasswordException, ServiceUnavailableException {
        try {
            Optional<User> userOptional = this.getUserRepository().findByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userOptional.isEmpty()) {
                throw new AuthenticationFailedException("Authentication failed while attempting to change the password for the user (" + username + ")");
            }
            User user = userOptional.get();
            if (user.getPasswordAttempts() != null && user.getPasswordAttempts() > this.maxPasswordAttempts) {
                throw new UserLockedException(username);
            }
            String encodedNewPassword = this.passwordEncoder.encode((CharSequence)newPassword);
            if (!this.passwordEncoder.matches((CharSequence)password, user.getPassword())) {
                throw new AuthenticationFailedException("Authentication failed while attempting to change the password for the user (" + username + ")");
            }
            if (this.isPasswordInHistory(user.getId(), newPassword)) {
                throw new ExistingPasswordException(username);
            }
            LocalDateTime passwordExpiry = LocalDateTime.now();
            passwordExpiry = passwordExpiry.plus(this.passwordExpiryMonths, ChronoUnit.MONTHS);
            this.getUserRepository().changePassword(user.getId(), encodedNewPassword, 0, Optional.of(passwordExpiry));
            this.getUserRepository().savePasswordInPasswordHistory(user.getId(), encodedNewPassword);
        }
        catch (AuthenticationFailedException | ExistingPasswordException | UserLockedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to change the password for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void createGroup(Group group) throws DuplicateGroupException, ServiceUnavailableException {
        try {
            if (this.getGroupRepository().existsByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), group.getName())) {
                throw new DuplicateGroupException(group.getName());
            }
            group.setId(UuidCreator.getShortPrefixComb());
            this.getGroupRepository().saveAndFlush(group);
        }
        catch (DuplicateGroupException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the group (" + group.getName() + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void createUser(User user, boolean expiredPassword, boolean userLocked) throws DuplicateUserException, ServiceUnavailableException {
        try {
            if (this.getUserRepository().existsByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), user.getUsername())) {
                throw new DuplicateUserException(user.getUsername());
            }
            user.setId(UuidCreator.getShortPrefixComb());
            String encodedNewPassword = !this.isNullOrEmpty(user.getPassword()) ? this.passwordEncoder.encode((CharSequence)user.getPassword()) : this.passwordEncoder.encode((CharSequence)PasswordUtil.generateRandomPassword());
            user.setPassword(encodedNewPassword);
            if (userLocked) {
                user.setPasswordAttempts(this.maxPasswordAttempts);
            } else {
                user.setPasswordAttempts(0);
            }
            if (expiredPassword) {
                user.setPasswordExpiry(LocalDateTime.now());
            } else {
                LocalDateTime passwordExpiry = LocalDateTime.now();
                passwordExpiry = passwordExpiry.plus(this.passwordExpiryMonths, ChronoUnit.MONTHS);
                user.setPasswordExpiry(passwordExpiry);
            }
            this.getUserRepository().saveAndFlush(user);
            this.getUserRepository().savePasswordInPasswordHistory(user.getId(), encodedNewPassword);
        }
        catch (DuplicateUserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the user (" + user.getUsername() + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void deleteGroup(String groupName) throws GroupNotFoundException, ExistingGroupMembersException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            if (this.getGroupRepository().countUsersById(groupIdOptional.get()) > 0L) {
                throw new ExistingGroupMembersException(groupName);
            }
            this.getGroupRepository().deleteById(groupIdOptional.get());
        }
        catch (ExistingGroupMembersException | GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void deleteUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            this.getUserRepository().deleteById(userIdOptional.get());
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<User> findUsers(List<UserAttribute> userAttributes) throws InvalidAttributeException, ServiceUnavailableException {
        try {
            User userCriteria = new User();
            userCriteria.setUserDirectoryId(this.getUserDirectoryId());
            for (UserAttribute userAttribute : userAttributes) {
                if (userAttribute.getName().equalsIgnoreCase("status")) {
                    userCriteria.setStatus(UserStatus.fromCode(userAttribute.getValue()));
                    continue;
                }
                if (userAttribute.getName().equalsIgnoreCase("email")) {
                    userCriteria.setEmail(userAttribute.getValue());
                    continue;
                }
                if (userAttribute.getName().equalsIgnoreCase("name")) {
                    userCriteria.setName(userAttribute.getValue());
                    continue;
                }
                if (userAttribute.getName().equalsIgnoreCase("preferredName")) {
                    userCriteria.setPreferredName(userAttribute.getValue());
                    continue;
                }
                if (userAttribute.getName().equalsIgnoreCase("phoneNumber")) {
                    userCriteria.setPhoneNumber(userAttribute.getValue());
                    continue;
                }
                if (userAttribute.getName().equalsIgnoreCase("mobileNumber")) {
                    userCriteria.setMobileNumber(userAttribute.getValue());
                    continue;
                }
                if (userAttribute.getName().equalsIgnoreCase("username")) {
                    userCriteria.setUsername(userAttribute.getValue());
                    continue;
                }
                throw new InvalidAttributeException(userAttribute.getName());
            }
            ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues().withIgnoreCase().withStringMatcher(ExampleMatcher.StringMatcher.CONTAINING);
            return this.getUserRepository().findAll(Example.of((Object)userCriteria, (ExampleMatcher)matcher));
        }
        catch (InvalidAttributeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to find the users for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public UserDirectoryCapabilities getCapabilities() {
        return INTERNAL_USER_DIRECTORY_CAPABILITIES;
    }

    @Override
    public List<String> getFunctionCodesForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            return this.getUserRepository().getFunctionCodesByUserId(userIdOptional.get());
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the function codes for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public Group getGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<Group> groupOptional = this.getGroupRepository().findByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupOptional.isPresent()) {
                return groupOptional.get();
            }
            throw new GroupNotFoundException(groupName);
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<String> getGroupNames() throws ServiceUnavailableException {
        try {
            return this.getGroupRepository().getNamesByUserDirectoryId(this.getUserDirectoryId());
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the group names for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<String> getGroupNamesForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            return this.getUserRepository().getGroupNamesByUserId(userIdOptional.get());
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the names of the groups the user (" + username + ") is a member of for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<Group> getGroups() throws ServiceUnavailableException {
        try {
            return this.getGroupRepository().findByUserDirectoryId(this.getUserDirectoryId());
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the groups for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public Groups getGroups(String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws ServiceUnavailableException {
        try {
            if (pageIndex == null) {
                pageIndex = 0;
            }
            if (pageSize == null) {
                pageSize = this.maxFilteredGroups;
            }
            PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, this.maxFilteredGroups), (Sort.Direction)(sortDirection == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC), (String[])new String[]{"name"});
            Page<Group> groupPage = StringUtils.hasText((String)filter) ? this.getGroupRepository().findFiltered(this.getUserDirectoryId(), "%" + filter + "%", (Pageable)pageRequest) : this.getGroupRepository().findByUserDirectoryId(this.getUserDirectoryId(), (Pageable)pageRequest);
            return new Groups(this.getUserDirectoryId(), groupPage.toList(), groupPage.getTotalElements(), filter, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the filtered groups for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<Group> getGroupsForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            return this.getUserRepository().getGroupsByUserId(userIdOptional.get());
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the groups the user is a member of (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<GroupMember> getMembersForGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            List<String> usernames = this.getGroupRepository().getUsernamesForGroup(this.getUserDirectoryId(), groupIdOptional.get());
            ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
            for (String username : usernames) {
                groupMembers.add(new GroupMember(this.getUserDirectoryId(), groupName, GroupMemberType.USER, username));
            }
            return groupMembers;
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the group members for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public GroupMembers getMembersForGroup(String groupName, String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            if (pageIndex == null) {
                pageIndex = 0;
            }
            if (pageSize == null) {
                pageSize = this.maxFilteredGroups;
            }
            PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, this.maxFilteredGroupMembers));
            Page<String> usernamesForGroupPage = StringUtils.hasText((String)filter) ? this.getGroupRepository().getFilteredUsernamesForGroup(this.getUserDirectoryId(), groupIdOptional.get(), "%" + filter + "%", (Pageable)pageRequest) : this.getGroupRepository().getUsernamesForGroup(this.getUserDirectoryId(), groupIdOptional.get(), (Pageable)pageRequest);
            ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
            for (String username : usernamesForGroupPage) {
                groupMembers.add(new GroupMember(this.getUserDirectoryId(), groupName, GroupMemberType.USER, username));
            }
            if (sortDirection == null || sortDirection == SortDirection.ASCENDING) {
                groupMembers.sort(Comparator.comparing(GroupMember::getMemberName));
            } else {
                groupMembers.sort(Comparator.comparing(GroupMember::getMemberName).reversed());
            }
            return new GroupMembers(this.getUserDirectoryId(), groupName, groupMembers, usernamesForGroupPage.getTotalElements(), filter, sortDirection, pageIndex, pageSize);
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the group members for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<String> getRoleCodesForGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            return this.getGroupRepository().getRoleCodesByGroupId(groupIdOptional.get());
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the role codes for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<String> getRoleCodesForUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            return this.getUserRepository().getRoleCodesByUserId(userIdOptional.get());
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the role codes for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<GroupRole> getRolesForGroup(String groupName) throws GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            ArrayList<GroupRole> groupRoles = new ArrayList<GroupRole>();
            for (String roleCode : this.getGroupRepository().getRoleCodesByGroupId(groupIdOptional.get())) {
                groupRoles.add(new GroupRole(this.getUserDirectoryId(), groupName, roleCode));
            }
            return groupRoles;
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the roles for the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public User getUser(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<User> userOptional = this.getUserRepository().findByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userOptional.isPresent()) {
                return userOptional.get();
            }
            throw new UserNotFoundException(username);
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public String getUserName(String username) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<String> userNameOptional = this.getUserRepository().getNameByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userNameOptional.isPresent()) {
                return userNameOptional.get();
            }
            throw new UserNotFoundException(username);
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the name of the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public List<User> getUsers() throws ServiceUnavailableException {
        try {
            return this.getUserRepository().findByUserDirectoryId(this.getUserDirectoryId());
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the users for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public Users getUsers(String filter, UserSortBy sortBy, SortDirection sortDirection, Integer pageIndex, Integer pageSize) throws ServiceUnavailableException {
        try {
            PageRequest pageRequest = null;
            if (pageIndex == null) {
                pageIndex = 0;
            }
            if (pageSize == null) {
                pageSize = this.maxFilteredUsers;
            }
            if (sortBy == UserSortBy.USERNAME) {
                pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, this.maxFilteredUsers), (Sort.Direction)(sortDirection == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC), (String[])new String[]{"username"});
            } else if (sortBy == UserSortBy.NAME) {
                pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, this.maxFilteredUsers), (Sort.Direction)(sortDirection == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC), (String[])new String[]{"name"});
            } else if (sortBy == UserSortBy.PREFERRED_NAME) {
                pageRequest = PageRequest.of((int)pageIndex, (int)Math.min(pageSize, this.maxFilteredUsers), (Sort.Direction)(sortDirection == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC), (String[])new String[]{"preferredName"});
            }
            Page<User> userPage = StringUtils.hasText((String)filter) ? this.getUserRepository().findFiltered(this.getUserDirectoryId(), "%" + filter + "%", (Pageable)pageRequest) : this.getUserRepository().findByUserDirectoryId(this.getUserDirectoryId(), (Pageable)pageRequest);
            return new Users(this.getUserDirectoryId(), userPage.toList(), userPage.getTotalElements(), filter, sortBy, sortDirection, pageIndex, pageSize);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the filtered users for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public boolean isExistingUser(String username) throws ServiceUnavailableException {
        try {
            return this.getUserRepository().existsByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to check whether the user (" + username + ") is an existing user for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public boolean isUserInGroup(String groupName, String username) throws UserNotFoundException, GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            return this.getUserRepository().isUserInGroup(userIdOptional.get(), groupIdOptional.get());
        }
        catch (GroupNotFoundException | UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to check if the user (" + username + ") is in the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void removeMemberFromGroup(String groupName, GroupMemberType memberType, String memberName) throws GroupNotFoundException, GroupMemberNotFoundException, ServiceUnavailableException {
        if (memberType != GroupMemberType.USER) {
            throw new ServiceUnavailableException("Unsupported group member type (" + memberType.description() + ")");
        }
        try {
            this.removeUserFromGroup(groupName, memberName);
        }
        catch (UserNotFoundException e) {
            throw new GroupMemberNotFoundException(memberType, memberName);
        }
    }

    @Override
    public void removeRoleFromGroup(String groupName, String roleCode) throws GroupNotFoundException, GroupRoleNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            if (this.getGroupRepository().removeRoleFromGroup(groupIdOptional.get(), roleCode) == 0) {
                throw new GroupRoleNotFoundException(roleCode);
            }
        }
        catch (GroupNotFoundException | GroupRoleNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to remove the role (" + roleCode + ") from the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void removeUserFromGroup(String groupName, String username) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<UUID> groupIdOptional = this.getGroupRepository().getIdByUserDirectoryIdAndNameIgnoreCase(this.getUserDirectoryId(), groupName);
            if (groupIdOptional.isEmpty()) {
                throw new GroupNotFoundException(groupName);
            }
            Optional<UUID> userIdOptional = this.getUserRepository().getIdByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userIdOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            this.getGroupRepository().removeUserFromGroup(groupIdOptional.get(), userIdOptional.get());
        }
        catch (GroupNotFoundException | UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to remove the user (" + username + ") from the group (" + groupName + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void resetPassword(String username, String newPassword) throws UserNotFoundException, UserLockedException, ExistingPasswordException, ServiceUnavailableException {
        try {
            Optional<User> userOptional = this.getUserRepository().findByUserDirectoryIdAndUsernameIgnoreCase(this.getUserDirectoryId(), username);
            if (userOptional.isEmpty()) {
                throw new UserNotFoundException(username);
            }
            User user = userOptional.get();
            if (user.getPasswordAttempts() != null && user.getPasswordAttempts() > this.maxPasswordAttempts) {
                throw new UserLockedException(username);
            }
            String encodedNewPassword = this.passwordEncoder.encode((CharSequence)newPassword);
            if (this.isPasswordInHistory(user.getId(), newPassword)) {
                throw new ExistingPasswordException(username);
            }
            LocalDateTime passwordExpiry = LocalDateTime.now();
            passwordExpiry = passwordExpiry.plus(this.passwordExpiryMonths, ChronoUnit.MONTHS);
            this.getUserRepository().resetPassword(user.getId(), encodedNewPassword, passwordExpiry);
            this.getUserRepository().savePasswordInPasswordHistory(user.getId(), encodedNewPassword);
        }
        catch (ExistingPasswordException | UserLockedException | UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to reset the password for the user (" + username + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void updateGroup(Group group) throws GroupNotFoundException, ServiceUnavailableException {
        try {
            Optional<Group> groupOptional = this.getGroupRepository().findByUserDirectoryIdAndNameIgnoreCase(group.getUserDirectoryId(), group.getName());
            if (groupOptional.isEmpty()) {
                throw new GroupNotFoundException(group.getName());
            }
            Group existingGroup = groupOptional.get();
            existingGroup.setDescription(group.getDescription());
            this.getGroupRepository().saveAndFlush(existingGroup);
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the group (" + group.getName() + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    @Override
    public void updateUser(User user, boolean expirePassword, boolean lockUser) throws UserNotFoundException, ServiceUnavailableException {
        try {
            Optional<User> userOptional = this.getUserRepository().findByUserDirectoryIdAndUsernameIgnoreCase(user.getUserDirectoryId(), user.getUsername());
            if (userOptional.isEmpty()) {
                throw new UserNotFoundException(user.getUsername());
            }
            User existingUser = userOptional.get();
            if (user.getName() != null) {
                existingUser.setName(user.getName());
            }
            if (user.getPreferredName() != null) {
                existingUser.setPreferredName(user.getPreferredName());
            }
            if (user.getEmail() != null) {
                existingUser.setEmail(user.getEmail());
            }
            if (user.getPhoneNumber() != null) {
                existingUser.setPhoneNumber(user.getPhoneNumber());
            }
            if (user.getMobileNumber() != null) {
                existingUser.setMobileNumber(user.getMobileNumber());
            }
            if (StringUtils.hasText((String)user.getPassword())) {
                existingUser.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
            }
            if (lockUser) {
                existingUser.setPasswordAttempts(this.maxPasswordAttempts);
            } else if (user.getPasswordAttempts() != null) {
                existingUser.setPasswordAttempts(user.getPasswordAttempts());
            }
            if (expirePassword) {
                existingUser.setPasswordExpiry(LocalDateTime.now());
            } else if (user.getPasswordExpiry() != null) {
                existingUser.setPasswordExpiry(user.getPasswordExpiry());
            }
            this.getUserRepository().saveAndFlush(existingUser);
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the user (" + user.getUsername() + ") for the user directory (" + this.getUserDirectoryId() + ")", e);
        }
    }

    private boolean isPasswordInHistory(UUID userId, String password) {
        LocalDateTime after = LocalDateTime.now();
        after = after.minus(this.passwordHistoryMonths, ChronoUnit.MONTHS);
        for (String historicalPassword : this.getUserRepository().getPasswordHistory(userId, after)) {
            if (!this.passwordEncoder.matches((CharSequence)password, historicalPassword)) continue;
            return true;
        }
        return false;
    }
}

