/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.security.AuthenticationFailedException;
import africa.absa.inception.security.DuplicateGroupException;
import africa.absa.inception.security.DuplicateUserException;
import africa.absa.inception.security.ExistingGroupMembersException;
import africa.absa.inception.security.ExistingPasswordException;
import africa.absa.inception.security.ExpiredPasswordException;
import africa.absa.inception.security.Group;
import africa.absa.inception.security.GroupMember;
import africa.absa.inception.security.GroupMemberNotFoundException;
import africa.absa.inception.security.GroupMemberType;
import africa.absa.inception.security.GroupMembers;
import africa.absa.inception.security.GroupNotFoundException;
import africa.absa.inception.security.GroupRole;
import africa.absa.inception.security.GroupRoleNotFoundException;
import africa.absa.inception.security.Groups;
import africa.absa.inception.security.InvalidAttributeException;
import africa.absa.inception.security.PasswordChangeReason;
import africa.absa.inception.security.RoleNotFoundException;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserAttribute;
import africa.absa.inception.security.UserDirectoryCapabilities;
import africa.absa.inception.security.UserLockedException;
import africa.absa.inception.security.UserNotFoundException;
import africa.absa.inception.security.UserSortBy;
import africa.absa.inception.security.Users;
import java.util.List;

interface IUserDirectory {
    public void addMemberToGroup(String var1, GroupMemberType var2, String var3) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void addRoleToGroup(String var1, String var2) throws GroupNotFoundException, RoleNotFoundException, ServiceUnavailableException;

    public void addUserToGroup(String var1, String var2) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void adminChangePassword(String var1, String var2, boolean var3, boolean var4, boolean var5, PasswordChangeReason var6) throws UserNotFoundException, ServiceUnavailableException;

    public void authenticate(String var1, String var2) throws AuthenticationFailedException, UserLockedException, ExpiredPasswordException, UserNotFoundException, ServiceUnavailableException;

    public void changePassword(String var1, String var2, String var3) throws AuthenticationFailedException, UserLockedException, ExistingPasswordException, ServiceUnavailableException;

    public void createGroup(Group var1) throws DuplicateGroupException, ServiceUnavailableException;

    public void createUser(User var1, boolean var2, boolean var3) throws DuplicateUserException, ServiceUnavailableException;

    public void deleteGroup(String var1) throws GroupNotFoundException, ExistingGroupMembersException, ServiceUnavailableException;

    public void deleteUser(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public List<User> findUsers(List<UserAttribute> var1) throws InvalidAttributeException, ServiceUnavailableException;

    public UserDirectoryCapabilities getCapabilities() throws ServiceUnavailableException;

    public List<String> getFunctionCodesForUser(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public Group getGroup(String var1) throws GroupNotFoundException, ServiceUnavailableException;

    public List<String> getGroupNames() throws ServiceUnavailableException;

    public List<String> getGroupNamesForUser(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public List<Group> getGroups() throws ServiceUnavailableException;

    public Groups getGroups(String var1, SortDirection var2, Integer var3, Integer var4) throws ServiceUnavailableException;

    public List<Group> getGroupsForUser(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public List<GroupMember> getMembersForGroup(String var1) throws GroupNotFoundException, ServiceUnavailableException;

    public GroupMembers getMembersForGroup(String var1, String var2, SortDirection var3, Integer var4, Integer var5) throws GroupNotFoundException, ServiceUnavailableException;

    public List<String> getRoleCodesForGroup(String var1) throws GroupNotFoundException, ServiceUnavailableException;

    public List<String> getRoleCodesForUser(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public List<GroupRole> getRolesForGroup(String var1) throws GroupNotFoundException, ServiceUnavailableException;

    public User getUser(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public String getUserName(String var1) throws UserNotFoundException, ServiceUnavailableException;

    public List<User> getUsers() throws ServiceUnavailableException;

    public Users getUsers(String var1, UserSortBy var2, SortDirection var3, Integer var4, Integer var5) throws ServiceUnavailableException;

    public boolean isExistingUser(String var1) throws ServiceUnavailableException;

    public boolean isUserInGroup(String var1, String var2) throws UserNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public void removeMemberFromGroup(String var1, GroupMemberType var2, String var3) throws GroupNotFoundException, GroupMemberNotFoundException, ServiceUnavailableException;

    public void removeRoleFromGroup(String var1, String var2) throws GroupNotFoundException, GroupRoleNotFoundException, ServiceUnavailableException;

    public void removeUserFromGroup(String var1, String var2) throws GroupNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void resetPassword(String var1, String var2) throws UserNotFoundException, UserLockedException, ExistingPasswordException, ServiceUnavailableException;

    public void updateGroup(Group var1) throws GroupNotFoundException, ServiceUnavailableException;

    public void updateUser(User var1, boolean var2, boolean var3) throws UserNotFoundException, ServiceUnavailableException;
}

