/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.security.AuthenticationFailedException;
import africa.absa.inception.security.DuplicateFunctionException;
import africa.absa.inception.security.DuplicateGroupException;
import africa.absa.inception.security.DuplicateTenantException;
import africa.absa.inception.security.DuplicateUserDirectoryException;
import africa.absa.inception.security.DuplicateUserException;
import africa.absa.inception.security.ExistingGroupMembersException;
import africa.absa.inception.security.ExistingPasswordException;
import africa.absa.inception.security.ExpiredPasswordException;
import africa.absa.inception.security.Function;
import africa.absa.inception.security.FunctionNotFoundException;
import africa.absa.inception.security.Group;
import africa.absa.inception.security.GroupMember;
import africa.absa.inception.security.GroupMemberNotFoundException;
import africa.absa.inception.security.GroupMemberType;
import africa.absa.inception.security.GroupMembers;
import africa.absa.inception.security.GroupNotFoundException;
import africa.absa.inception.security.GroupRole;
import africa.absa.inception.security.GroupRoleNotFoundException;
import africa.absa.inception.security.Groups;
import africa.absa.inception.security.InvalidAttributeException;
import africa.absa.inception.security.InvalidSecurityCodeException;
import africa.absa.inception.security.PasswordChangeReason;
import africa.absa.inception.security.Role;
import africa.absa.inception.security.RoleNotFoundException;
import africa.absa.inception.security.Tenant;
import africa.absa.inception.security.TenantNotFoundException;
import africa.absa.inception.security.TenantUserDirectoryNotFoundException;
import africa.absa.inception.security.Tenants;
import africa.absa.inception.security.User;
import africa.absa.inception.security.UserAttribute;
import africa.absa.inception.security.UserDirectories;
import africa.absa.inception.security.UserDirectory;
import africa.absa.inception.security.UserDirectoryCapabilities;
import africa.absa.inception.security.UserDirectoryNotFoundException;
import africa.absa.inception.security.UserDirectorySummaries;
import africa.absa.inception.security.UserDirectorySummary;
import africa.absa.inception.security.UserDirectoryType;
import africa.absa.inception.security.UserDirectoryTypeNotFoundException;
import africa.absa.inception.security.UserLockedException;
import africa.absa.inception.security.UserNotFoundException;
import africa.absa.inception.security.UserSortBy;
import africa.absa.inception.security.Users;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public interface ISecurityService {
    public static final UUID ADMINISTRATORS_GROUP_ID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final String ADMINISTRATORS_GROUP_NAME = "Administrators";
    public static final String ADMINISTRATOR_ROLE_CODE = "Administrator";
    public static final String ADMINISTRATOR_USERNAME = "administrator";
    public static final UUID DEFAULT_TENANT_ID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final UUID DEFAULT_USER_DIRECTORY_ID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final String INTERNAL_USER_DIRECTORY_TYPE = "InternalUserDirectory";
    public static final String LDAP_USER_DIRECTORY_TYPE = "LDAPUserDirectory";
    public static final String PASSWORD_RESETTER_ROLE_CODE = "PasswordResetter";
    public static final String TENANT_ADMINISTRATOR_ROLE_CODE = "TenantAdministrator";

    public void addMemberToGroup(UUID var1, String var2, GroupMemberType var3, String var4) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void addRoleToGroup(UUID var1, String var2, String var3) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, RoleNotFoundException, ServiceUnavailableException;

    public void addUserDirectoryToTenant(UUID var1, UUID var2) throws InvalidArgumentException, TenantNotFoundException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public void addUserToGroup(UUID var1, String var2, String var3) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void adminChangePassword(UUID var1, String var2, String var3, boolean var4, boolean var5, boolean var6, PasswordChangeReason var7) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public UUID authenticate(String var1, String var2) throws InvalidArgumentException, AuthenticationFailedException, UserLockedException, ExpiredPasswordException, UserNotFoundException, ServiceUnavailableException;

    public UUID changePassword(String var1, String var2, String var3) throws InvalidArgumentException, AuthenticationFailedException, UserLockedException, ExistingPasswordException, ServiceUnavailableException;

    public void createFunction(Function var1) throws InvalidArgumentException, DuplicateFunctionException, ServiceUnavailableException;

    public void createGroup(Group var1) throws InvalidArgumentException, UserDirectoryNotFoundException, DuplicateGroupException, ServiceUnavailableException;

    public Optional<UserDirectory> createTenant(Tenant var1, boolean var2) throws InvalidArgumentException, DuplicateTenantException, ServiceUnavailableException;

    public void createUser(User var1, boolean var2, boolean var3) throws InvalidArgumentException, UserDirectoryNotFoundException, DuplicateUserException, ServiceUnavailableException;

    public void createUserDirectory(UserDirectory var1) throws InvalidArgumentException, DuplicateUserDirectoryException, ServiceUnavailableException;

    public void deleteFunction(String var1) throws InvalidArgumentException, FunctionNotFoundException, ServiceUnavailableException;

    public void deleteGroup(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ExistingGroupMembersException, ServiceUnavailableException;

    public void deleteTenant(UUID var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public void deleteUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void deleteUserDirectory(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public List<User> findUsers(UUID var1, List<UserAttribute> var2) throws InvalidArgumentException, UserDirectoryNotFoundException, InvalidAttributeException, ServiceUnavailableException;

    public Function getFunction(String var1) throws InvalidArgumentException, FunctionNotFoundException, ServiceUnavailableException;

    public List<String> getFunctionCodesForUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public List<Function> getFunctions() throws ServiceUnavailableException;

    public Group getGroup(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public List<String> getGroupNames(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public List<String> getGroupNamesForUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public List<Group> getGroups(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public Groups getGroups(UUID var1, String var2, SortDirection var3, Integer var4, Integer var5) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public List<Group> getGroupsForUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public List<GroupMember> getMembersForGroup(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public GroupMembers getMembersForGroup(UUID var1, String var2, String var3, SortDirection var4, Integer var5, Integer var6) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public List<String> getRoleCodesForGroup(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public List<String> getRoleCodesForUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public List<Role> getRoles() throws ServiceUnavailableException;

    public List<GroupRole> getRolesForGroup(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public Tenant getTenant(UUID var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public List<UUID> getTenantIdsForUserDirectory(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public String getTenantName(UUID var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public List<Tenant> getTenants() throws ServiceUnavailableException;

    public Tenants getTenants(String var1, SortDirection var2, Integer var3, Integer var4) throws InvalidArgumentException, ServiceUnavailableException;

    public List<Tenant> getTenantsForUserDirectory(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public User getUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public List<UserDirectory> getUserDirectories() throws ServiceUnavailableException;

    public UserDirectories getUserDirectories(String var1, SortDirection var2, Integer var3, Integer var4) throws InvalidArgumentException, ServiceUnavailableException;

    public List<UserDirectory> getUserDirectoriesForTenant(UUID var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public UserDirectory getUserDirectory(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public UserDirectoryCapabilities getUserDirectoryCapabilities(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public Optional<UUID> getUserDirectoryIdForUser(String var1) throws InvalidArgumentException, ServiceUnavailableException;

    public List<UUID> getUserDirectoryIdsForTenant(UUID var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public List<UUID> getUserDirectoryIdsForUser(String var1) throws InvalidArgumentException, UserNotFoundException, ServiceUnavailableException;

    public String getUserDirectoryName(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public UserDirectorySummaries getUserDirectorySummaries(String var1, SortDirection var2, Integer var3, Integer var4) throws InvalidArgumentException, ServiceUnavailableException;

    public List<UserDirectorySummary> getUserDirectorySummariesForTenant(UUID var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public UserDirectoryType getUserDirectoryTypeForUserDirectory(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, UserDirectoryTypeNotFoundException, ServiceUnavailableException;

    public List<UserDirectoryType> getUserDirectoryTypes() throws ServiceUnavailableException;

    public String getUserName(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public List<User> getUsers(UUID var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public Users getUsers(UUID var1, String var2, UserSortBy var3, SortDirection var4, Integer var5, Integer var6) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public void initiatePasswordReset(String var1, String var2, boolean var3) throws InvalidArgumentException, UserNotFoundException, ServiceUnavailableException;

    public void initiatePasswordReset(String var1, String var2, boolean var3, String var4) throws InvalidArgumentException, UserNotFoundException, ServiceUnavailableException;

    public boolean isExistingUser(UUID var1, String var2) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;

    public boolean isUserInGroup(UUID var1, String var2, String var3) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public void reloadUserDirectories() throws ServiceUnavailableException;

    public void removeMemberFromGroup(UUID var1, String var2, GroupMemberType var3, String var4) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, GroupMemberNotFoundException, ServiceUnavailableException;

    public void removeRoleFromGroup(UUID var1, String var2, String var3) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, GroupRoleNotFoundException, ServiceUnavailableException;

    public void removeUserDirectoryFromTenant(UUID var1, UUID var2) throws InvalidArgumentException, TenantNotFoundException, TenantUserDirectoryNotFoundException, ServiceUnavailableException;

    public void removeUserFromGroup(UUID var1, String var2, String var3) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void resetPassword(String var1, String var2, String var3) throws InvalidArgumentException, InvalidSecurityCodeException, UserLockedException, ExistingPasswordException, ServiceUnavailableException;

    public void updateFunction(Function var1) throws InvalidArgumentException, FunctionNotFoundException, ServiceUnavailableException;

    public void updateGroup(Group var1) throws InvalidArgumentException, UserDirectoryNotFoundException, GroupNotFoundException, ServiceUnavailableException;

    public void updateTenant(Tenant var1) throws InvalidArgumentException, TenantNotFoundException, ServiceUnavailableException;

    public void updateUser(User var1, boolean var2, boolean var3) throws InvalidArgumentException, UserDirectoryNotFoundException, UserNotFoundException, ServiceUnavailableException;

    public void updateUserDirectory(UserDirectory var1) throws InvalidArgumentException, UserDirectoryNotFoundException, ServiceUnavailableException;
}

