/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A group role association")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectoryId", "groupName", "roleCode"})
public class GroupRole
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The name of the group", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String groupName;
    @Schema(description="The code for the role", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String roleCode;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory the group is associated with", required=true)
    @JsonProperty(required=true)
    @NotNull
    private UUID userDirectoryId;

    public GroupRole() {
    }

    public GroupRole(UUID userDirectoryId, String groupName, String roleCode) {
        this.userDirectoryId = userDirectoryId;
        this.groupName = groupName;
        this.roleCode = roleCode;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public void setUserDirectoryId(UUID userDirectoryId) {
        this.userDirectoryId = userDirectoryId;
    }
}

