/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Group;
import africa.absa.inception.security.Role;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface GroupRepository
extends JpaRepository<Group, UUID> {
    @Modifying
    @Query(value="insert into security.role_to_group_map(role_code, group_id) values (:roleCode, :groupId)", nativeQuery=true)
    public void addRoleToGroup(@Param(value="groupId") UUID var1, @Param(value="roleCode") String var2);

    @Modifying
    @Query(value="insert into security.user_to_group_map(user_id, group_id) values (:userId, :groupId)", nativeQuery=true)
    public void addUserToGroup(@Param(value="groupId") UUID var1, @Param(value="userId") UUID var2);

    public long countByUserDirectoryId(UUID var1);

    @Query(value="select count(g.id) from Group g where (lower(g.name) like lower(:filter)) and g.userDirectoryId = :userDirectoryId")
    public long countFiltered(@Param(value="userDirectoryId") UUID var1, @Param(value="filter") String var2);

    @Query(value="select count(u.id) from Group g join g.users as u where g.userDirectoryId = :userDirectoryId and g.id = :groupId and (lower(u.username) like lower(:filter))")
    public long countFilteredUsernamesForGroup(@Param(value="userDirectoryId") UUID var1, @Param(value="groupId") UUID var2, @Param(value="filter") String var3);

    @Query(value="select count(role_code) from security.role_to_group_map where role_code = :roleCode and group_id = :groupId", nativeQuery=true)
    public long countGroupRole(@Param(value="groupId") UUID var1, @Param(value="roleCode") String var2);

    @Query(value="select count(u.id) from Group g join g.users as u where g.userDirectoryId = :userDirectoryId and g.id = :groupId")
    public long countUsernamesForGroup(@Param(value="userDirectoryId") UUID var1, @Param(value="groupId") UUID var2);

    @Query(value="select count(u.id) from Group g join g.users as u where g.id = :groupId")
    public long countUsersById(@Param(value="groupId") UUID var1);

    @Modifying
    @Query(value="delete from Group g where g.id = :groupId")
    public void deleteById(@Param(value="groupId") UUID var1);

    @Transactional
    public boolean existsByUserDirectoryIdAndNameIgnoreCase(UUID var1, String var2);

    public List<Group> findByUserDirectoryId(UUID var1);

    public Page<Group> findByUserDirectoryId(UUID var1, Pageable var2);

    public Optional<Group> findByUserDirectoryIdAndNameIgnoreCase(UUID var1, String var2);

    @Query(value="select g from Group g where (lower(g.name) like lower(:filter)) and g.userDirectoryId = :userDirectoryId")
    public Page<Group> findFiltered(@Param(value="userDirectoryId") UUID var1, @Param(value="filter") String var2, Pageable var3);

    @Query(value="select u.username from Group g join g.users as u where g.userDirectoryId = :userDirectoryId and g.id = :groupId and (lower(u.username) like lower(:filter))")
    public Page<String> getFilteredUsernamesForGroup(@Param(value="userDirectoryId") UUID var1, @Param(value="groupId") UUID var2, @Param(value="filter") String var3, Pageable var4);

    @Query(value="select distinct f.code from Group g join g.roles as r join r.functions as f where g.userDirectoryId = :userDirectoryId and lower(g.name) in :groupNames")
    public List<String> getFunctionCodesByUserDirectoryIdAndGroupNames(@Param(value="userDirectoryId") UUID var1, @Param(value="groupNames") List<String> var2);

    @Query(value="select g.id from Group g where g.userDirectoryId = :userDirectoryId and lower(g.name) like lower(:name)")
    public Optional<UUID> getIdByUserDirectoryIdAndNameIgnoreCase(@Param(value="userDirectoryId") UUID var1, @Param(value="name") String var2);

    @Query(value="select g.name from Group g where g.userDirectoryId = :userDirectoryId")
    public List<String> getNamesByUserDirectoryId(@Param(value="userDirectoryId") UUID var1);

    @Query(value="select r.code from Group g join g.roles as r where g.id = :groupId")
    public List<String> getRoleCodesByGroupId(@Param(value="groupId") UUID var1);

    @Query(value="select distinct r.code from Group g join g.roles as r where g.userDirectoryId = :userDirectoryId and lower(g.name) in :groupNames")
    public List<String> getRoleCodesByUserDirectoryIdAndGroupNames(@Param(value="userDirectoryId") UUID var1, @Param(value="groupNames") List<String> var2);

    @Query(value="select r from Group g join g.roles as r where g.id = :groupId")
    public List<Role> getRolesByGroupId(@Param(value="groupId") UUID var1);

    @Query(value="select u.username from Group g join g.users as u where g.userDirectoryId = :userDirectoryId and g.id = :groupId")
    public List<String> getUsernamesForGroup(@Param(value="userDirectoryId") UUID var1, @Param(value="groupId") UUID var2);

    @Query(value="select u.username from Group g join g.users as u where g.userDirectoryId = :userDirectoryId and g.id = :groupId")
    public Page<String> getUsernamesForGroup(@Param(value="userDirectoryId") UUID var1, @Param(value="groupId") UUID var2, Pageable var3);

    @Modifying
    @Query(value="delete from security.role_to_group_map where group_id=:groupId and role_code = :roleCode", nativeQuery=true)
    public int removeRoleFromGroup(@Param(value="groupId") UUID var1, @Param(value="roleCode") String var2);

    @Modifying
    @Query(value="delete from security.user_to_group_map where group_id=:groupId and user_id = :userId", nativeQuery=true)
    public void removeUserFromGroup(@Param(value="groupId") UUID var1, @Param(value="userId") UUID var2);
}

