/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.core.sorting.SortDirection;
import africa.absa.inception.security.GroupMember;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

@Schema(description="The results of a request to retrieve a list of group members")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectoryId", "groupName", "groupMembers", "total", "filter", "sortDirection", "pageIndex", "pageSize"})
public class GroupMembers
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The optional filter that was applied to the group members")
    @JsonProperty
    private String filter;
    @Schema(description="The group members", required=true)
    @JsonProperty(required=true)
    private List<GroupMember> groupMembers;
    @Schema(description="The name of the group the group members are associated with", required=true)
    @JsonProperty(required=true)
    private String groupName;
    @Schema(description="The optional page index")
    @JsonProperty
    private Integer pageIndex;
    @Schema(description="The optional page size")
    @JsonProperty
    private Integer pageSize;
    @Schema(description="The optional sort direction that was applied to the group members")
    @JsonProperty
    private SortDirection sortDirection;
    @Schema(description="The total number of group members", required=true)
    @JsonProperty(required=true)
    private long total;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory the group members are associated with", required=true)
    @JsonProperty(required=true)
    private UUID userDirectoryId;

    public GroupMembers() {
    }

    public GroupMembers(UUID userDirectoryId, String groupName, List<GroupMember> groupMembers, long total, String filter, SortDirection sortDirection, Integer pageIndex, Integer pageSize) {
        this.userDirectoryId = userDirectoryId;
        this.groupName = groupName;
        this.groupMembers = groupMembers;
        this.total = total;
        this.filter = filter;
        this.sortDirection = sortDirection;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<GroupMember> getGroupMembers() {
        return this.groupMembers;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public Long getTotal() {
        return this.total;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }
}

