/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The group member type")
public enum GroupMemberType {
    USER("user", "User"),
    GROUP("group", "Group");

    private final String code;
    private final String description;

    private GroupMemberType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonCreator
    public static GroupMemberType fromCode(String code) {
        switch (code) {
            case "user": {
                return USER;
            }
            case "group": {
                return GROUP;
            }
        }
        throw new RuntimeException("Failed to determine the group member type with the invalid code (" + code + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

