/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.GroupMemberType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A group member association")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectoryId", "groupName", "memberName", "memberType"})
public class GroupMember
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The name of the group", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String groupName;
    @Schema(description="The name of the group member", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    private @NotNull @Size(min=1, max=100) String memberName;
    @Schema(description="The group member type", required=true)
    @JsonProperty(required=true)
    @NotNull
    private GroupMemberType memberType;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory the group is associated with", required=true)
    @JsonProperty(required=true)
    @NotNull
    private UUID userDirectoryId;

    public GroupMember() {
    }

    public GroupMember(UUID userDirectoryId, String groupName, GroupMemberType memberType, String memberName) {
        this.userDirectoryId = userDirectoryId;
        this.groupName = groupName;
        this.memberType = memberType;
        this.memberName = memberName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public GroupMemberType getMemberType() {
        return this.memberType;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public void setMemberType(GroupMemberType memberType) {
        this.memberType = memberType;
    }

    public void setUserDirectoryId(UUID userDirectoryId) {
        this.userDirectoryId = userDirectoryId;
    }
}

