/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Role;
import africa.absa.inception.security.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A group of users")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"userDirectoryId", "name", "description"})
@Entity
@Table(schema="security", name="groups")
public class Group
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @JsonIgnore
    @Column(name="created", nullable=false, updatable=false)
    private LocalDateTime created;
    @Schema(description="The description for the group")
    @JsonProperty
    @Size(max=100)
    @Column(name="description", length=100)
    private @Size(max=100) String description;
    @JsonIgnore
    @Id
    @Column(name="id", nullable=false)
    private UUID id;
    @Schema(description="The name of the group", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(schema="security", name="role_to_group_map", joinColumns={@JoinColumn(name="group_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="role_code", referencedColumnName="code")})
    private Set<Role> roles = new HashSet<Role>();
    @JsonIgnore
    @Column(name="updated", insertable=false)
    private LocalDateTime updated;
    @Schema(description="The Universally Unique Identifier (UUID) for the user directory the group is associated with", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Column(name="user_directory_id", nullable=false)
    private UUID userDirectoryId;
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(schema="security", name="user_to_group_map", joinColumns={@JoinColumn(name="group_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="user_id", referencedColumnName="id")})
    private Set<User> users = new HashSet<User>();

    public Group() {
    }

    public Group(String name) {
        this.name = name;
    }

    public Group(UUID userDirectoryId, String name, String description) {
        this.userDirectoryId = userDirectoryId;
        this.name = name;
        this.description = description;
    }

    public void addRole(Role role) {
        this.roles.removeIf(existingRole -> Objects.equals(existingRole.getCode(), role.getCode()));
        this.roles.add(role);
        role.getGroups().add(this);
    }

    public void addUser(User user) {
        this.users.removeIf(existingUser -> Objects.equals(existingUser.getId(), user.getId()));
        this.users.add(user);
        user.getGroups().add(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Group other = (Group)object;
        return Objects.equals(this.id, other.id);
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public UUID getUserDirectoryId() {
        return this.userDirectoryId;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public void removeRole(Role role) {
        this.roles.remove(role);
        role.getGroups().remove(this);
    }

    public void removeUser(User user) {
        this.users.remove(user);
        user.getGroups().remove(this);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void setUserDirectoryId(UUID userDirectoryId) {
        this.userDirectoryId = userDirectoryId;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    @PrePersist
    protected void onCreate() {
        this.created = LocalDateTime.now();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updated = LocalDateTime.now();
    }
}

