/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.Role;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A discrete unit of functionality for an application that can be assigned to a role")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"code", "name", "description"})
@Entity
@Table(schema="security", name="functions")
public class Function
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @Schema(description="The code for the function", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Id
    @Column(name="code", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String code;
    @Schema(description="The description for the function")
    @JsonProperty
    @Size(max=100)
    @Column(name="description", length=100)
    private @Size(max=100) String description;
    @Schema(description="The name of the function", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @JsonIgnore
    @ManyToMany(mappedBy="functions")
    private Set<Role> roles = new HashSet<Role>();

    public Function() {
    }

    public Function(String code, String name, String description) {
        this.code = code;
        this.name = name;
        this.description = description;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Function other = (Function)object;
        return Objects.equals(this.code, other.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public int hashCode() {
        return this.code == null ? 0 : this.code.hashCode();
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }
}

