/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.security;

import africa.absa.inception.security.PasswordResetRepository;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BackgroundPasswordResetExpiry {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundPasswordResetExpiry.class);
    private final PasswordResetRepository passwordResetRepository;
    @Value(value="${inception.application.security.passwordResetExpiry:900}")
    private int passwordResetExpiry;

    public BackgroundPasswordResetExpiry(PasswordResetRepository passwordResetRepository) {
        this.passwordResetRepository = passwordResetRepository;
    }

    @Scheduled(cron="0 * * * * *")
    @Transactional
    public void expirePasswordResets() {
        try {
            LocalDateTime requestedBefore = LocalDateTime.now();
            requestedBefore = requestedBefore.minus(this.passwordResetExpiry, ChronoUnit.SECONDS);
            this.passwordResetRepository.expirePasswordResets(LocalDateTime.now(), requestedBefore);
        }
        catch (Throwable e) {
            logger.error("Failed to expire the password resets", e);
        }
    }
}

